/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles.impetuses;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockEntityLookingImpetus
extends BlockEntityAbstractImpetus {
    public static final int MAX_LOOK_AMOUNT = 30;
    public static final String TAG_LOOK_AMOUNT = "look_amount";
    private int lookAmount = 0;

    public BlockEntityLookingImpetus(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.IMPETUS_LOOK_TILE, pWorldPosition, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState bs, BlockEntityLookingImpetus self) {
        int newLook;
        if (((Boolean)bs.getValue((Property)BlockCircleComponent.ENERGIZED)).booleanValue()) {
            return;
        }
        int prevLookAmt = self.lookAmount;
        int range = 20;
        List players = level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos.offset(-range, -range, -range), pos.offset(range, range, range)));
        ServerPlayer looker = null;
        for (ServerPlayer player : players) {
            ItemStack hat = player.getItemBySlot(EquipmentSlot.HEAD);
            if (!hat.isEmpty() && hat.is(Blocks.CARVED_PUMPKIN.asItem())) continue;
            Vec3 lookEnd = player.getLookAngle().scale((double)((float)range / 1.5f));
            BlockHitResult hit = level.clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(lookEnd), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)player));
            if (hit.getType() != HitResult.Type.BLOCK || !hit.getBlockPos().equals((Object)pos)) continue;
            looker = player;
            break;
        }
        if ((newLook = Mth.clamp((int)(prevLookAmt + (looker == null ? -1 : 1)), (int)0, (int)30)) != prevLookAmt) {
            if (newLook == 30) {
                self.lookAmount = 0;
                self.startExecution(looker);
            } else {
                if (newLook % 5 == 1) {
                    float t = (float)newLook / 30.0f;
                    float pitch = Mth.lerp((float)t, (float)0.5f, (float)1.2f);
                    float volume = Mth.lerp((float)t, (float)0.2f, (float)1.2f);
                    level.playSound(null, pos, HexSounds.IMPETUS_LOOK_TICK, SoundSource.BLOCKS, volume, pitch);
                }
                self.lookAmount = newLook;
                self.setChanged();
            }
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        super.saveModData(tag);
        tag.putInt(TAG_LOOK_AMOUNT, this.lookAmount);
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        super.loadModData(tag);
        this.lookAmount = tag.getInt(TAG_LOOK_AMOUNT);
    }
}

