/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.akashic;

import at.petrak.hexcasting.api.misc.TriPredicate;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface AkashicFloodfiller {
    default public boolean canBeFloodedThrough(BlockPos pos, BlockState state, Level world) {
        return true;
    }

    @Nullable
    public static BlockPos floodFillFor(BlockPos start, Level world, TriPredicate<BlockPos, BlockState, Level> isTarget) {
        return AkashicFloodfiller.floodFillFor(start, world, 0.0f, isTarget, 128);
    }

    @Nullable
    public static BlockPos floodFillFor(BlockPos start, Level world, float skipChance, TriPredicate<BlockPos, BlockState, Level> isTarget, int maxRange) {
        HashSet<BlockPos> seenBlocks = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        todo.add(start);
        HashSet<BlockPos> skippedBlocks = new HashSet<BlockPos>();
        while (!todo.isEmpty()) {
            BlockPos here = (BlockPos)todo.remove();
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = here.relative(dir);
                if (neighbor.distSqr((Vec3i)start) > (double)(maxRange * maxRange) || !seenBlocks.add(neighbor)) continue;
                BlockState bs = world.getBlockState(neighbor);
                if (isTarget.test(neighbor, bs, world)) {
                    if (world.random.nextFloat() > skipChance) {
                        return neighbor;
                    }
                    skippedBlocks.add(neighbor);
                }
                if (!AkashicFloodfiller.canItBeFloodedThrough(neighbor, bs, world)) continue;
                todo.add(neighbor);
            }
        }
        if (!skippedBlocks.isEmpty()) {
            return (BlockPos)skippedBlocks.iterator().next();
        }
        return null;
    }

    public static boolean canItBeFloodedThrough(BlockPos pos, BlockState state, Level world) {
        Block block = state.getBlock();
        if (!(block instanceof AkashicFloodfiller)) {
            return false;
        }
        AkashicFloodfiller flooder = (AkashicFloodfiller)block;
        return flooder.canBeFloodedThrough(pos, state, world);
    }
}

