/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks;

import at.petrak.hexcasting.common.blocks.entity.BlockEntityQuenchedAllay;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BlockQuenchedAllay
extends Block
implements EntityBlock {
    public static final int VARIANTS = 4;

    public BlockQuenchedAllay(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityQuenchedAllay(this, pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        ConjureParticleOptions options = new ConjureParticleOptions(8991416);
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        for (Direction direction : Direction.values()) {
            int dX = direction.getStepX();
            int dY = direction.getStepY();
            int dZ = direction.getStepZ();
            int count = rand.nextInt(10) / 4;
            for (int i = 0; i < count; ++i) {
                double pX = center.x + (dX == 0 ? Mth.nextDouble((RandomSource)rand, (double)-0.5, (double)0.5) : (double)dX * 0.55);
                double pY = center.y + (dY == 0 ? Mth.nextDouble((RandomSource)rand, (double)-0.5, (double)0.5) : (double)dY * 0.55);
                double pZ = center.z + (dZ == 0 ? Mth.nextDouble((RandomSource)rand, (double)-0.5, (double)0.5) : (double)dZ * 0.55);
                double vPerp = Mth.nextDouble((RandomSource)rand, (double)0.0, (double)0.01);
                double vX = vPerp * (double)dX;
                double vY = vPerp * (double)dY;
                double vZ = vPerp * (double)dZ;
                level.addParticle((ParticleOptions)options, pX, pY, pZ, vX, vY, vZ);
            }
        }
    }
}

