/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.sound;

import at.petrak.hexcasting.client.gui.GuiSpellcasting;
import at.petrak.hexcasting.common.lib.HexSounds;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lat/petrak/hexcasting/client/sound/GridSoundInstance;", "Lnet/minecraft/client/resources/sounds/AbstractTickableSoundInstance;", "player", "Lnet/minecraft/world/entity/player/Player;", "(Lnet/minecraft/world/entity/player/Player;)V", "mousePosX", "", "getMousePosX", "()D", "setMousePosX", "(D)V", "mousePosY", "getMousePosY", "setMousePosY", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "calculateVectorFromPitchAndYaw", "Lnet/minecraft/world/phys/Vec3;", "pitch", "", "yaw", "tick", "", "Companion", "hexcasting-common-1.20.1"})
public final class GridSoundInstance
extends AbstractTickableSoundInstance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    private double mousePosX;
    private double mousePosY;
    public static final double PAN_SCALE = 0.5;

    public GridSoundInstance(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super(HexSounds.CASTING_AMBIANCE, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.mousePosX = 0.5;
        this.mousePosY = 0.5;
        Vec3 lookVec = this.player.getLookAngle();
        Vec3 playerPos = this.player.getEyePosition();
        this.x = playerPos.x + lookVec.x;
        this.y = playerPos.y + lookVec.y;
        this.z = playerPos.z + lookVec.z;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
        this.looping = true;
        this.delay = 0;
        this.relative = false;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final double getMousePosX() {
        return this.mousePosX;
    }

    public final void setMousePosX(double d) {
        this.mousePosX = d;
    }

    public final double getMousePosY() {
        return this.mousePosY;
    }

    public final void setMousePosY(double d) {
        this.mousePosY = d;
    }

    public void tick() {
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (!(screen instanceof GuiSpellcasting)) {
            this.stop();
        } else {
            Vec3 horizontalPlanarVector = this.calculateVectorFromPitchAndYaw(this.player.getXRot() + (float)90, this.player.getYRot());
            Vec3 verticalPlanarVector = this.calculateVectorFromPitchAndYaw(this.player.getXRot(), this.player.getYRot() + (float)90);
            Vec3 normalVector = this.calculateVectorFromPitchAndYaw(this.player.getXRot(), this.player.getYRot());
            Vec3 newPos = this.player.getEyePosition().add(normalVector).add(horizontalPlanarVector.scale(1.0 * (this.mousePosX - 0.5))).add(verticalPlanarVector.scale(1.0 * (this.mousePosY - 0.5)));
            this.x = newPos.x;
            this.y = newPos.y;
            this.z = newPos.z;
        }
    }

    private final Vec3 calculateVectorFromPitchAndYaw(float pitch, float yaw) {
        float radiansPitch = pitch * ((float)Math.PI / 180);
        float radiansYaw = -yaw * ((float)Math.PI / 180);
        double xComponent = Mth.cos((float)radiansYaw);
        double zComponent = Mth.sin((float)radiansYaw);
        double azimuthHorizontal = Mth.cos((float)radiansPitch);
        double azimuthVertical = Mth.sin((float)radiansPitch);
        return new Vec3(zComponent * azimuthHorizontal, -azimuthVertical, xComponent * azimuthHorizontal);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lat/petrak/hexcasting/client/sound/GridSoundInstance$Companion;", "", "()V", "PAN_SCALE", "", "hexcasting-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

