/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.PatternColors;
import at.petrak.hexcasting.client.render.PatternRenderer;
import at.petrak.hexcasting.client.render.PatternSettings;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;

public class WorldlyPatternRenderHelpers {
    public static final PatternSettings SCROLL_SETTINGS = new PatternSettings("scroll", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.STATIC);
    public static final PatternSettings READABLE_SCROLL_SETTINGS = new PatternSettings("scroll_readable", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.READABLE);
    public static final PatternSettings WORLDLY_SETTINGS = new PatternSettings("worldly", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.STATIC);
    public static final PatternSettings WORLDLY_SETTINGS_WOBBLY = new PatternSettings("wobbly_world", PatternSettings.PositionSettings.paddedSquare(0.125), PatternSettings.StrokeSettings.fromStroke(0.05), PatternSettings.ZappySettings.WOBBLY);
    private static final int[] WALL_ROTATIONS = new int[]{180, 270, 0, 90};
    private static final Vec3i[] SLATE_FACINGS = new Vec3i[]{new Vec3i(0, -1, 0), new Vec3i(-1, -1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1)};
    private static final Vec3[] WALL_NORMALS = new Vec3[]{new Vec3(0.0, 0.0, -1.0), new Vec3(-1.0, 0.0, 0.0), new Vec3(0.0, 0.0, -1.0), new Vec3(-1.0, 0.0, 0.0)};
    private static final Vec3i[] SLATE_FLOORCEIL_FACINGS = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(1, 0, 1), new Vec3i(0, 0, 1)};
    private static final Vec3i[] BLOCK_FACINGS = new Vec3i[]{new Vec3i(0, -1, 1), new Vec3i(0, -1, 0), new Vec3i(-1, -1, 0), new Vec3i(-1, -1, 1)};

    public static void renderPatternForScroll(HexPattern pattern, EntityWallScroll scroll, PoseStack ps, MultiBufferSource bufSource, int light, int blockSize, boolean showStrokeOrder) {
        ps.pushPose();
        ps.translate((float)(-blockSize) / 2.0f, (float)(-blockSize) / 2.0f, 0.03125f);
        ps.last().normal().mul((Matrix3fc)new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f));
        WorldlyPatternRenderHelpers.renderPattern(pattern, showStrokeOrder ? READABLE_SCROLL_SETTINGS : SCROLL_SETTINGS, showStrokeOrder ? PatternColors.READABLE_SCROLL_COLORS : PatternColors.DEFAULT_PATTERN_COLOR, scroll.getPos().hashCode(), ps, bufSource, null, null, light, blockSize);
        ps.popPose();
    }

    public static void renderPatternForSlate(BlockEntitySlate tile, HexPattern pattern, PoseStack ps, MultiBufferSource buffer, int light, BlockState bs) {
        boolean isOnWall = bs.getValue(BlockSlate.ATTACH_FACE) == AttachFace.WALL;
        boolean isOnCeiling = bs.getValue(BlockSlate.ATTACH_FACE) == AttachFace.CEILING;
        int facing = ((Direction)bs.getValue((Property)BlockSlate.FACING)).get2DDataValue();
        boolean wombly = (Boolean)bs.getValue((Property)BlockSlate.ENERGIZED);
        ps.pushPose();
        Vec3 normal = null;
        if (isOnWall) {
            ps.mulPose(Axis.ZP.rotationDegrees(180.0f));
            Vec3i tV = SLATE_FACINGS[facing % 4];
            ps.translate((float)tV.getX(), (float)tV.getY(), (float)tV.getZ());
            ps.mulPose(Axis.YP.rotationDegrees((float)WALL_ROTATIONS[facing % 4]));
            normal = WALL_NORMALS[facing % 4];
        } else {
            Vec3i tV = SLATE_FLOORCEIL_FACINGS[facing % 4];
            ps.translate((float)tV.getX(), (float)tV.getY(), (float)tV.getZ());
            ps.mulPose(Axis.YP.rotationDegrees((float)(facing * -90)));
            ps.mulPose(Axis.XP.rotationDegrees((float)(90 * (isOnCeiling ? -1 : 1))));
            if (isOnCeiling) {
                ps.translate(0.0f, -1.0f, 1.0f);
            }
        }
        WorldlyPatternRenderHelpers.renderPattern(pattern, wombly ? WORLDLY_SETTINGS_WOBBLY : WORLDLY_SETTINGS, wombly ? PatternColors.SLATE_WOBBLY_PURPLE_COLOR : PatternColors.DEFAULT_PATTERN_COLOR, tile.getBlockPos().hashCode(), ps, buffer, normal, null, light, 1);
        ps.popPose();
    }

    public static void renderPatternForAkashicBookshelf(BlockEntityAkashicBookshelf tile, HexPattern pattern, PoseStack ps, MultiBufferSource buffer, int light, BlockState bs) {
        int facing = ((Direction)bs.getValue((Property)BlockAkashicBookshelf.FACING)).get2DDataValue();
        ps.pushPose();
        ps.mulPose(Axis.ZP.rotationDegrees(180.0f));
        Vec3i tV = BLOCK_FACINGS[facing % 4];
        ps.translate((float)tV.getX(), (float)tV.getY(), (float)tV.getZ());
        ps.mulPose(Axis.YP.rotationDegrees((float)WALL_ROTATIONS[facing % 4]));
        int actualLight = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos().relative((Direction)bs.getValue((Property)BlockAkashicBookshelf.FACING)));
        WorldlyPatternRenderHelpers.renderPattern(pattern, WORLDLY_SETTINGS, PatternColors.DEFAULT_PATTERN_COLOR, tile.getBlockPos().hashCode(), ps, buffer, WALL_NORMALS[facing % 4].multiply(-1.0, -1.0, -1.0), Float.valueOf(-0.02f), actualLight, 1);
        ps.popPose();
    }

    public static void renderPattern(HexPattern pattern, PatternSettings patSets, PatternColors patColors, double seed, PoseStack ps, MultiBufferSource bufSource, Vec3 normal, @Nullable Float zOffset, int light, int blockSize) {
        ps.pushPose();
        float z = zOffset != null ? zOffset.floatValue() : -0.0725f;
        normal = normal != null ? normal : new Vec3(0.0, 0.0, -1.0);
        ps.translate(0.0f, 0.0f, z);
        ps.scale((float)blockSize, (float)blockSize, 1.0f);
        PoseStack noNormalInv = new PoseStack();
        noNormalInv.scale(1.0f, 1.0f, -1.0f);
        ps.mulPoseMatrix(noNormalInv.last().pose());
        PatternRenderer.renderPattern(pattern, ps, new PatternRenderer.WorldlyBits(bufSource, light, normal), patSets, patColors, seed, blockSize * 512);
        ps.popPose();
    }
}

