/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.client.ScryingLensOverlayRegistry;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.lib.HexBlocks;
import com.mojang.datafixers.util.Pair;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.MapColor;

public class ScryingLensOverlays {
    public static void addScryingLensStuff() {
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.getBlock() instanceof BlockAbstractImpetus, (lines, state, pos, observer, world, direction) -> {
            BlockEntity patt1640$temp = world.getBlockEntity(pos);
            if (patt1640$temp instanceof BlockEntityAbstractImpetus) {
                BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)patt1640$temp;
                beai.applyScryingLensOverlay(lines, state, pos, observer, world, direction);
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.NOTE_BLOCK, (lines, state, pos, observer, world, direction) -> {
            int note = (Integer)state.getValue((Property)NoteBlock.NOTE);
            float rCol = Math.max(0.0f, Mth.sin((float)(((float)note / 24.0f + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float gCol = Math.max(0.0f, Mth.sin((float)(((float)note / 24.0f + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            float bCol = Math.max(0.0f, Mth.sin((float)(((float)note / 24.0f + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
            int noteColor = 0xFF000000 | Mth.color((float)rCol, (float)gCol, (float)bCol);
            NoteBlockInstrument instrument = (NoteBlockInstrument)state.getValue((Property)NoteBlock.INSTRUMENT);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.MUSIC_DISC_CHIRP), (Object)Component.literal((String)String.valueOf(instrument.ordinal())).withStyle(ScryingLensOverlays.color(ScryingLensOverlays.instrumentColor(instrument)))));
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.NOTE_BLOCK), (Object)Component.literal((String)String.valueOf(note)).withStyle(ScryingLensOverlays.color(noteColor))));
        });
        ScryingLensOverlayRegistry.addDisplayer(HexBlocks.AKASHIC_BOOKSHELF, (lines, state, pos, observer, world, direction) -> {
            BlockEntityAkashicBookshelf tile;
            CompoundTag iotaTag;
            BlockEntity patt3143$temp = world.getBlockEntity(pos);
            if (patt3143$temp instanceof BlockEntityAkashicBookshelf && (iotaTag = (tile = (BlockEntityAkashicBookshelf)patt3143$temp).getIotaTag()) != null) {
                Component display = IotaType.getDisplay(iotaTag);
                lines.add(new Pair((Object)new ItemStack((ItemLike)Items.BOOK), (Object)display));
            }
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.COMPARATOR, (lines, state, pos, observer, world, direction) -> {
            int comparatorValue = state.getAnalogOutputSignal(world, pos);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.REDSTONE), (Object)Component.literal((String)(comparatorValue == -1 ? "" : String.valueOf(comparatorValue))).withStyle(ScryingLensOverlays.redstoneColor(comparatorValue))));
            boolean compare = state.getValue((Property)ComparatorBlock.MODE) == ComparatorMode.COMPARE;
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.REDSTONE_TORCH), (Object)Component.literal((String)(compare ? ">=" : "-")).withStyle(ScryingLensOverlays.redstoneColor(compare ? 0 : 15))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.POWERED_RAIL, (lines, state, pos, observer, world, direction) -> {
            int power = ScryingLensOverlays.getPoweredRailStrength(world, pos, state);
            lines.add(new Pair((Object)new ItemStack((ItemLike)Items.POWERED_RAIL), (Object)Component.literal((String)String.valueOf(power)).withStyle(ScryingLensOverlays.redstoneColor(power, 9))));
        });
        ScryingLensOverlayRegistry.addDisplayer(Blocks.REPEATER, (lines, state, pos, observer, world, direction) -> lines.add(new Pair((Object)new ItemStack((ItemLike)Items.CLOCK), (Object)Component.literal((String)String.valueOf(state.getValue((Property)RepeaterBlock.DELAY))).withStyle(ChatFormatting.YELLOW))));
        ScryingLensOverlayRegistry.addPredicateDisplayer((state, pos, observer, world, direction) -> state.isSignalSource() && !state.is(Blocks.COMPARATOR), (lines, state, pos, observer, world, direction) -> {
            int signalStrength = 0;
            if (state.getBlock() instanceof RedStoneWireBlock) {
                signalStrength = (Integer)state.getValue((Property)RedStoneWireBlock.POWER);
            } else {
                for (Direction dir : Direction.values()) {
                    signalStrength = Math.max(signalStrength, state.getSignal((BlockGetter)world, pos, dir));
                }
            }
            lines.add(0, new Pair((Object)new ItemStack((ItemLike)Items.REDSTONE), (Object)Component.literal((String)String.valueOf(signalStrength)).withStyle(ScryingLensOverlays.redstoneColor(signalStrength))));
        });
    }

    private static int getPoweredRailStrength(Level level, BlockPos pos, BlockState state) {
        if (level.hasNeighborSignal(pos)) {
            return 9;
        }
        int positiveValue = ScryingLensOverlays.findPoweredRailSignal(level, pos, state, true, 0);
        int negativeValue = ScryingLensOverlays.findPoweredRailSignal(level, pos, state, false, 0);
        return Math.max(positiveValue, negativeValue);
    }

    private static int findPoweredRailSignal(Level level, BlockPos pos, BlockState state, boolean travelPositive, int depth) {
        if (depth >= 8) {
            return 0;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        boolean descending = true;
        RailShape shape = (RailShape)state.getValue((Property)PoweredRailBlock.SHAPE);
        switch (shape) {
            case NORTH_SOUTH: {
                if (travelPositive) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case EAST_WEST: {
                if (travelPositive) {
                    --x;
                    break;
                }
                ++x;
                break;
            }
            case ASCENDING_EAST: {
                if (travelPositive) {
                    --x;
                } else {
                    ++x;
                    ++y;
                    descending = false;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (travelPositive) {
                    --x;
                    ++y;
                    descending = false;
                } else {
                    ++x;
                }
                shape = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (travelPositive) {
                    ++z;
                } else {
                    --z;
                    ++y;
                    descending = false;
                }
                shape = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (travelPositive) {
                    ++z;
                    ++y;
                    descending = false;
                } else {
                    --z;
                }
                shape = RailShape.NORTH_SOUTH;
            }
        }
        int power = ScryingLensOverlays.getPowerFromRail(level, new BlockPos(x, y, z), travelPositive, depth, shape);
        if (power > 0) {
            return power;
        }
        if (descending) {
            return ScryingLensOverlays.getPowerFromRail(level, new BlockPos(x, y - 1, z), travelPositive, depth, shape);
        }
        return 0;
    }

    private static UnaryOperator<Style> color(int color) {
        return style -> style.withColor(TextColor.fromRgb((int)color));
    }

    private static UnaryOperator<Style> redstoneColor(int power) {
        return ScryingLensOverlays.redstoneColor(power, 15);
    }

    private static UnaryOperator<Style> redstoneColor(int power, int max) {
        return ScryingLensOverlays.color(RedStoneWireBlock.getColorForPower((int)Mth.clamp((int)(power * max / 15), (int)0, (int)15)));
    }

    private static int instrumentColor(NoteBlockInstrument instrument) {
        return switch (instrument) {
            case NoteBlockInstrument.BASEDRUM -> MapColor.STONE.col;
            case NoteBlockInstrument.SNARE, NoteBlockInstrument.XYLOPHONE, NoteBlockInstrument.PLING -> MapColor.SAND.col;
            case NoteBlockInstrument.HAT -> MapColor.QUARTZ.col;
            case NoteBlockInstrument.BASS -> MapColor.WOOD.col;
            case NoteBlockInstrument.FLUTE -> MapColor.CLAY.col;
            case NoteBlockInstrument.BELL -> MapColor.GOLD.col;
            case NoteBlockInstrument.GUITAR -> MapColor.WOOL.col;
            case NoteBlockInstrument.CHIME -> MapColor.ICE.col;
            case NoteBlockInstrument.IRON_XYLOPHONE -> MapColor.METAL.col;
            case NoteBlockInstrument.COW_BELL -> MapColor.COLOR_BROWN.col;
            case NoteBlockInstrument.DIDGERIDOO -> MapColor.COLOR_ORANGE.col;
            case NoteBlockInstrument.BIT -> MapColor.EMERALD.col;
            case NoteBlockInstrument.BANJO -> MapColor.COLOR_YELLOW.col;
            default -> -1;
        };
    }

    private static int getPowerFromRail(Level level, BlockPos pos, boolean travelPositive, int depth, RailShape shape) {
        BlockState otherState = level.getBlockState(pos);
        if (!otherState.is(Blocks.POWERED_RAIL)) {
            return 0;
        }
        RailShape otherShape = (RailShape)otherState.getValue((Property)PoweredRailBlock.SHAPE);
        if (shape == RailShape.EAST_WEST && (otherShape == RailShape.NORTH_SOUTH || otherShape == RailShape.ASCENDING_NORTH || otherShape == RailShape.ASCENDING_SOUTH)) {
            return 0;
        }
        if (shape == RailShape.NORTH_SOUTH && (otherShape == RailShape.EAST_WEST || otherShape == RailShape.ASCENDING_EAST || otherShape == RailShape.ASCENDING_WEST)) {
            return 0;
        }
        if (((Boolean)otherState.getValue((Property)PoweredRailBlock.POWERED)).booleanValue()) {
            return level.hasNeighborSignal(pos) ? 8 - depth : ScryingLensOverlays.findPoweredRailSignal(level, pos, otherState, travelPositive, depth + 1);
        }
        return 0;
    }
}

