/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.RenderLib;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.world.phys.Vec2;

public interface HexPatternLike {
    public List<Vec2> getNonZappyPoints();

    public String getName();

    public Set<Integer> getDups();

    public static HexPatternLike of(HexPattern pat) {
        return new HexPatternLikeBecauseItsActuallyAHexPattern(pat);
    }

    public static HexPatternLike of(List<Vec2> lines, String name) {
        return new PureLines(lines, name);
    }

    public record HexPatternLikeBecauseItsActuallyAHexPattern(HexPattern pat) implements HexPatternLike
    {
        @Override
        public List<Vec2> getNonZappyPoints() {
            return this.pat.toLines(1.0f, Vec2.ZERO);
        }

        @Override
        public String getName() {
            return this.pat.getStartDir() + "-" + this.pat.anglesSignature();
        }

        @Override
        public Set<Integer> getDups() {
            return RenderLib.findDupIndices(this.pat.positions());
        }
    }

    public record PureLines(List<Vec2> lines, String name) implements HexPatternLike
    {
        @Override
        public List<Vec2> getNonZappyPoints() {
            return this.lines;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<Integer> getDups() {
            return RenderLib.findDupIndices(this.lines().stream().map(p -> new Vec2(p.x, p.y, (Vec2)p){
                final /* synthetic */ Vec2 val$p;
                {
                    this.val$p = vec2;
                    super(arg0, arg1);
                }

                public boolean equals(Object other) {
                    if (other instanceof Vec2) {
                        Vec2 otherVec = (Vec2)other;
                        return this.val$p.equals(otherVec);
                    }
                    return false;
                }

                public int hashCode() {
                    return Objects.hash(Float.valueOf(this.val$p.x), Float.valueOf(this.val$p.y));
                }
            }).toList());
        }
    }
}

