/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.entity;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.client.render.WorldlyPatternRenderHelpers;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WallScrollRenderer
extends EntityRenderer<EntityWallScroll> {
    private static final ResourceLocation PRISTINE_BG_LARGE = HexAPI.modLoc("textures/entity/scroll_large.png");
    private static final ResourceLocation PRISTINE_BG_MEDIUM = HexAPI.modLoc("textures/entity/scroll_medium.png");
    private static final ResourceLocation PRISTINE_BG_SMOL = HexAPI.modLoc("textures/block/scroll_paper.png");
    private static final ResourceLocation ANCIENT_BG_LARGE = HexAPI.modLoc("textures/entity/scroll_ancient_large.png");
    private static final ResourceLocation ANCIENT_BG_MEDIUM = HexAPI.modLoc("textures/entity/scroll_ancient_medium.png");
    private static final ResourceLocation ANCIENT_BG_SMOL = HexAPI.modLoc("textures/block/ancient_scroll_paper.png");

    public WallScrollRenderer(EntityRendererProvider.Context p_174008_) {
        super(p_174008_);
    }

    public void render(EntityWallScroll wallScroll, float yaw, float partialTicks, PoseStack ps, MultiBufferSource bufSource, int packedLight) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        ps.pushPose();
        ps.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        ps.mulPose(Axis.ZP.rotationDegrees(180.0f));
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)wallScroll.level(), (BlockPos)wallScroll.getPos());
        ps.pushPose();
        ps.translate((float)(-wallScroll.blockSize) / 2.0f, (float)(-wallScroll.blockSize) / 2.0f, 0.03125f);
        float dx = wallScroll.blockSize;
        float dy = wallScroll.blockSize;
        float dz = -0.0625f;
        float margin = 0.020833334f;
        PoseStack.Pose last = ps.last();
        Matrix4f mat = last.pose();
        Matrix3f norm = last.normal();
        RenderType layer = RenderType.entityCutout((ResourceLocation)this.getTextureLocation(wallScroll));
        VertexConsumer verts = bufSource.getBuffer(layer);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, 0.0f, margin, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f, margin, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, margin, 1.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, 0.0f, dz, margin, 0.0f, -1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, dz, 1.0f - margin, 0.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f - margin, 1.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, dz, 0.0f, 1.0f - margin, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, 0.0f, dy, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f);
        WallScrollRenderer.vertex(mat, norm, light, verts, dx, dy, dz, 1.0f, 1.0f - margin, 0.0f, 1.0f, 0.0f);
        ps.popPose();
        if (wallScroll.pattern != null) {
            WorldlyPatternRenderHelpers.renderPatternForScroll(wallScroll.pattern, wallScroll, ps, bufSource, light, wallScroll.blockSize, wallScroll.getShowsStrokeOrder());
        }
        ps.popPose();
        super.render((Entity)wallScroll, yaw, partialTicks, ps, bufSource, packedLight);
    }

    public ResourceLocation getTextureLocation(EntityWallScroll wallScroll) {
        if (wallScroll.isAncient) {
            if (wallScroll.blockSize <= 1) {
                return ANCIENT_BG_SMOL;
            }
            if (wallScroll.blockSize == 2) {
                return ANCIENT_BG_MEDIUM;
            }
            return ANCIENT_BG_LARGE;
        }
        if (wallScroll.blockSize <= 1) {
            return PRISTINE_BG_SMOL;
        }
        if (wallScroll.blockSize == 2) {
            return PRISTINE_BG_MEDIUM;
        }
        return PRISTINE_BG_LARGE;
    }

    private static void vertex(Matrix4f mat, Matrix3f normal, int light, VertexConsumer verts, float x, float y, float z, float u, float v, float nx, float ny, float nz) {
        verts.vertex(mat, x, y, z).color(-1).uv(u, v).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(light).normal(normal, nx, ny, nz).endVertex();
    }
}

