/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.utils;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n\u001a.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u001a\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r\u001a\u0016\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006\u001a\u0016\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006\u001a\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"compareMediaItem", "", "aMedia", "Lat/petrak/hexcasting/api/addldata/ADMediaHolder;", "bMedia", "extractMedia", "", "holder", "cost", "drainForBatteries", "", "simulate", "stack", "Lnet/minecraft/world/item/ItemStack;", "isMediaItem", "mediaBarColor", "media", "maxMedia", "mediaBarWidth", "scanPlayerForMediaStuff", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "hexcasting-common-1.20.1"})
@JvmName(name="MediaHelper")
public final class MediaHelper {
    public static final boolean isMediaItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ADMediaHolder aDMediaHolder = IXplatAbstractions.INSTANCE.findMediaHolder(stack);
        if (aDMediaHolder == null) {
            return false;
        }
        ADMediaHolder mediaHolder = aDMediaHolder;
        if (!mediaHolder.canProvide()) {
            return false;
        }
        return mediaHolder.withdrawMedia(-1L, true) > 0L;
    }

    @JvmOverloads
    public static final long extractMedia(@NotNull ItemStack stack, long cost, boolean drainForBatteries, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ADMediaHolder aDMediaHolder = IXplatAbstractions.INSTANCE.findMediaHolder(stack);
        if (aDMediaHolder == null) {
            return 0L;
        }
        ADMediaHolder mediaHolder = aDMediaHolder;
        return MediaHelper.extractMedia(mediaHolder, cost, drainForBatteries, simulate);
    }

    public static /* synthetic */ long extractMedia$default(ItemStack itemStack, long l, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return MediaHelper.extractMedia(itemStack, l, bl, bl2);
    }

    public static final long extractMedia(@NotNull ADMediaHolder holder, long cost, boolean drainForBatteries, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (drainForBatteries && !holder.canConstructBattery()) {
            return 0L;
        }
        return holder.withdrawMedia(cost, simulate);
    }

    public static /* synthetic */ long extractMedia$default(ADMediaHolder aDMediaHolder, long l, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            l = -1L;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return MediaHelper.extractMedia(aDMediaHolder, l, bl, bl2);
    }

    @NotNull
    public static final List<ADMediaHolder> scanPlayerForMediaStuff(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        List sources = new ArrayList();
        NonNullList nonNullList = player.getInventory().items;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"player.inventory.items");
        Collection collection = (Collection)nonNullList;
        NonNullList nonNullList2 = player.getInventory().armor;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList2, (String)"player.inventory.armor");
        Collection collection2 = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)nonNullList2));
        NonNullList nonNullList3 = player.getInventory().offhand;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList3, (String)"player.inventory.offhand");
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)collection2, (Iterable)((Iterable)nonNullList3));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ADMediaHolder holder;
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            ADMediaHolder aDMediaHolder = holder = HexAPI.instance().findMediaHolder(it);
            boolean bl2 = aDMediaHolder != null ? aDMediaHolder.canProvide() : false;
            if (!bl2) continue;
            sources.add(holder);
        }
        CollectionsKt.sortWith((List)sources, (arg_0, arg_1) -> MediaHelper.scanPlayerForMediaStuff$lambda$1(scanPlayerForMediaStuff.2.INSTANCE, arg_0, arg_1));
        CollectionsKt.reverse((List)sources);
        return sources;
    }

    public static final int compareMediaItem(@NotNull ADMediaHolder aMedia, @NotNull ADMediaHolder bMedia) {
        Intrinsics.checkNotNullParameter((Object)aMedia, (String)"aMedia");
        Intrinsics.checkNotNullParameter((Object)bMedia, (String)"bMedia");
        int priority = aMedia.getConsumptionPriority() - bMedia.getConsumptionPriority();
        if (priority != 0) {
            return priority;
        }
        return (int)RangesKt.coerceIn((long)(aMedia.withdrawMedia(-1L, true) - bMedia.withdrawMedia(-1L, true)), (long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE);
    }

    public static final int mediaBarColor(long media, long maxMedia) {
        float amt = maxMedia == 0L ? 0.0f : (float)media / (float)maxMedia;
        float r = Mth.lerp((float)amt, (float)84.0f, (float)254.0f);
        float g = Mth.lerp((float)amt, (float)57.0f, (float)203.0f);
        float b = Mth.lerp((float)amt, (float)138.0f, (float)230.0f);
        return Mth.color((float)(r / 255.0f), (float)(g / 255.0f), (float)(b / 255.0f));
    }

    public static final int mediaBarWidth(long media, long maxMedia) {
        float amt = maxMedia == 0L ? 0.0f : (float)media / (float)maxMedia;
        return MathKt.roundToInt((float)(13.0f * amt));
    }

    @JvmOverloads
    public static final long extractMedia(@NotNull ItemStack stack, long cost, boolean drainForBatteries) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return MediaHelper.extractMedia$default(stack, cost, drainForBatteries, false, 8, null);
    }

    @JvmOverloads
    public static final long extractMedia(@NotNull ItemStack stack, long cost) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return MediaHelper.extractMedia$default(stack, cost, false, false, 12, null);
    }

    @JvmOverloads
    public static final long extractMedia(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return MediaHelper.extractMedia$default(stack, 0L, false, false, 14, null);
    }

    private static final int scanPlayerForMediaStuff$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }
}

