/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.pigment;

import at.petrak.hexcasting.api.addldata.ADPigment;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec3;

public abstract class ColorProvider {
    private static final int[] MINIMUM_LUMINANCE_COLOR_WHEEL = new int[]{-14680064, -14671872, -16769024, -16768992, -16777184, -14680032};
    public static final ColorProvider MISSING = new ColorProvider(){

        @Override
        protected int getRawColor(float time, Vec3 position) {
            return -65316;
        }
    };

    protected abstract int getRawColor(float var1, Vec3 var2);

    public final int getColor(float time, Vec3 position) {
        int b;
        int g;
        int raw = this.getRawColor(time, position);
        int r = FastColor.ARGB32.red((int)raw);
        double luminance = (0.2126 * (double)r + 0.7152 * (double)(g = FastColor.ARGB32.green((int)raw)) + 0.0722 * (double)(b = FastColor.ARGB32.blue((int)raw))) / 255.0;
        if (luminance < 0.05) {
            int rawMod = ADPigment.morphBetweenColors(MINIMUM_LUMINANCE_COLOR_WHEEL, new Vec3(0.1, 0.1, 0.1), time / 20.0f / 20.0f, position);
            r += FastColor.ARGB32.red((int)rawMod);
            g += FastColor.ARGB32.green((int)rawMod);
            b += FastColor.ARGB32.blue((int)rawMod);
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

