/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.mishaps;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.lib.HexDamageTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lat/petrak/hexcasting/api/casting/mishaps/MishapAlreadyBrainswept;", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap;", "mob", "Lnet/minecraft/world/entity/Mob;", "(Lnet/minecraft/world/entity/Mob;)V", "getMob", "()Lnet/minecraft/world/entity/Mob;", "accentColor", "Lat/petrak/hexcasting/api/pigment/FrozenPigment;", "ctx", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "errorCtx", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap$Context;", "errorMessage", "Lnet/minecraft/network/chat/Component;", "execute", "", "stack", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "particleSpray", "Lat/petrak/hexcasting/api/casting/ParticleSpray;", "hexcasting-common-1.20.1"})
public final class MishapAlreadyBrainswept
extends Mishap {
    @NotNull
    private final Mob mob;

    public MishapAlreadyBrainswept(@NotNull Mob mob) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
    }

    @NotNull
    public final Mob getMob() {
        return this.mob;
    }

    @Override
    @NotNull
    public FrozenPigment accentColor(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        return this.dyeColor(DyeColor.GREEN);
    }

    @Override
    public void execute(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx, @NotNull List<Iota> stack) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        this.mob.hurt(this.mob.damageSources().source(HexDamageTypes.OVERCAST, (Entity)ctx.getCastingEntity()), this.mob.getHealth());
    }

    @Override
    @NotNull
    public ParticleSpray particleSpray(@NotNull CastingEnvironment ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Vec3 vec3 = this.mob.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"mob.eyePosition");
        return ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null);
    }

    @Override
    @NotNull
    protected Component errorMessage(@NotNull CastingEnvironment ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        return this.error("already_brainswept", new Object[0]);
    }
}

