/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Vec3Iota
extends Iota {
    public static IotaType<Vec3Iota> TYPE = new IotaType<Vec3Iota>(){

        @Override
        @Nullable
        public Vec3Iota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            return Vec3Iota.deserialize(tag);
        }

        @Override
        public Component display(Tag tag) {
            return Vec3Iota.display(Vec3Iota.deserialize(tag).getVec3());
        }

        @Override
        public int color() {
            return -53200;
        }
    };

    public Vec3Iota(@NotNull Vec3 datum) {
        super(HexIotaTypes.VEC3, datum);
    }

    public Vec3 getVec3() {
        Vec3 v = (Vec3)this.payload;
        return new Vec3(HexUtils.fixNAN(v.x), HexUtils.fixNAN(v.y), HexUtils.fixNAN(v.z));
    }

    @Override
    public boolean isTruthy() {
        Vec3 v = this.getVec3();
        return v.x != 0.0 || v.y != 0.0 || v.z != 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean toleratesOther(Iota that) {
        if (!Vec3Iota.typesMatch(this, that)) return false;
        if (!(that instanceof Vec3Iota)) return false;
        Vec3Iota viota = (Vec3Iota)that;
        if (!(this.getVec3().distanceToSqr(viota.getVec3()) < 1.0E-8)) return false;
        return true;
    }

    @Override
    @NotNull
    public Tag serialize() {
        return HexUtils.serializeToNBT(this.getVec3());
    }

    public static Vec3Iota deserialize(Tag tag) throws IllegalArgumentException {
        Vec3 vec;
        if (tag.getType() == LongArrayTag.TYPE) {
            LongArrayTag lat = (LongArrayTag)HexUtils.downcast(tag, LongArrayTag.TYPE);
            vec = HexUtils.vecFromNBT(lat.getAsLongArray());
        } else {
            vec = HexUtils.vecFromNBT((CompoundTag)HexUtils.downcast(tag, CompoundTag.TYPE));
        }
        return new Vec3Iota(vec);
    }

    public static Component display(double x, double y, double z) {
        return Component.literal((String)String.format("(%.2f, %.2f, %.2f)", x, y, z)).withStyle(ChatFormatting.RED);
    }

    public static Component display(Vec3 v) {
        return Vec3Iota.display(v.x, v.y, v.z);
    }
}

