/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.msgs.IMessage;
import at.petrak.hexcasting.common.msgs.MsgClearSpiralPatternsS2C;
import at.petrak.hexcasting.common.msgs.MsgNewSpellPatternC2S;
import at.petrak.hexcasting.common.msgs.MsgNewSpellPatternS2C;
import at.petrak.hexcasting.common.msgs.MsgNewSpiralPatternsS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class StaffCastEnv
extends PlayerBasedCastEnv {
    private final InteractionHand castingHand;
    private final Set<HexPattern> castPatterns = new HashSet<HexPattern>();
    private int soundsPlayed = 0;

    public StaffCastEnv(ServerPlayer caster, InteractionHand castingHand) {
        super(caster, castingHand);
        this.castingHand = castingHand;
    }

    @Override
    public void postExecution(CastResult result) {
        super.postExecution(result);
        Iota iota = result.component1();
        if (iota instanceof PatternIota) {
            PatternIota patternIota = (PatternIota)iota;
            this.castPatterns.add(patternIota.getPattern());
        }
        SoundEvent sound = result.getSound().sound();
        if (this.soundsPlayed < 100 && sound != null) {
            Vec3 soundPos = this.caster.position();
            this.world.playSound(null, soundPos.x, soundPos.y, soundPos.z, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
            ++this.soundsPlayed;
        }
    }

    @Override
    public void postCast(CastingImage image) {
        super.postCast(image);
        MsgNewSpiralPatternsS2C packet = new MsgNewSpiralPatternsS2C(this.caster.getUUID(), this.castPatterns.stream().toList(), Integer.MAX_VALUE);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(this.caster, packet);
        IXplatAbstractions.INSTANCE.sendPacketTracking((Entity)this.caster, packet);
        this.castPatterns.clear();
        this.soundsPlayed = 0;
    }

    @Override
    public long extractMediaEnvironment(long cost, boolean simulate) {
        if (this.caster.isCreative()) {
            return 0L;
        }
        boolean canOvercast = this.canOvercast();
        return this.extractMediaFromInventory(cost, canOvercast, simulate);
    }

    @Override
    public InteractionHand getCastingHand() {
        return this.castingHand;
    }

    @Override
    public FrozenPigment getPigment() {
        return HexAPI.instance().getColorizer((Player)this.caster);
    }

    public static void handleNewPatternOnServer(ServerPlayer sender, MsgNewSpellPatternC2S msg) {
        boolean cheatedPatternOverlap = false;
        List<ResolvedPattern> resolvedPatterns = msg.resolvedPatterns();
        if (!resolvedPatterns.isEmpty()) {
            HashSet<HexCoord> allPoints = new HashSet<HexCoord>();
            for (int i = 0; i < resolvedPatterns.size() - 1; ++i) {
                ResolvedPattern pat = resolvedPatterns.get(i);
                allPoints.addAll(pat.getPattern().positions(pat.getOrigin()));
            }
            ResolvedPattern currentResolvedPattern = resolvedPatterns.get(resolvedPatterns.size() - 1);
            List<HexCoord> currentSpellPoints = currentResolvedPattern.getPattern().positions(currentResolvedPattern.getOrigin());
            if (currentSpellPoints.stream().anyMatch(allPoints::contains)) {
                cheatedPatternOverlap = true;
            }
        }
        if (cheatedPatternOverlap) {
            return;
        }
        sender.awardStat(HexStatistics.PATTERNS_DRAWN);
        CastingVM vm = IXplatAbstractions.INSTANCE.getStaffcastVM(sender, msg.handUsed());
        ExecutionClientView clientInfo = vm.queueExecuteAndWrapIota(new PatternIota(msg.pattern()), sender.serverLevel());
        if (clientInfo.isStackClear()) {
            IXplatAbstractions.INSTANCE.setStaffcastImage(sender, null);
            IXplatAbstractions.INSTANCE.setPatterns(sender, List.of());
        } else {
            IXplatAbstractions.INSTANCE.setStaffcastImage(sender, vm.getImage().withOverriddenUsedOps(0L));
            if (!resolvedPatterns.isEmpty()) {
                resolvedPatterns.get(resolvedPatterns.size() - 1).setType(clientInfo.getResolutionType());
            }
            IXplatAbstractions.INSTANCE.setPatterns(sender, resolvedPatterns);
        }
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(sender, new MsgNewSpellPatternS2C(clientInfo, resolvedPatterns.size() - 1));
        Record packet = clientInfo.isStackClear() ? new MsgClearSpiralPatternsS2C(sender.getUUID()) : new MsgNewSpiralPatternsS2C(sender.getUUID(), List.of(msg.pattern()), Integer.MAX_VALUE);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(sender, (IMessage)((Object)packet));
        IXplatAbstractions.INSTANCE.sendPacketTracking((Entity)sender, (IMessage)((Object)packet));
        if (clientInfo.getResolutionType().getSuccess()) {
            new ParticleSpray(sender.position(), new Vec3(0.0, 1.5, 0.0), 0.4, 1.0471975511965976, 30).sprayParticles(sender.serverLevel(), IXplatAbstractions.INSTANCE.getPigment((Player)sender));
        }
    }
}

