/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.advancements.HexAdvancementTriggers;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.PlayerBasedMishapEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.common.lib.HexDamageTypes;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerBasedCastEnv
extends CastingEnvironment {
    public static final double DEFAULT_AMBIT_RADIUS = 32.0;
    private double ambitRadius;
    public static final double DEFAULT_SENTINEL_RADIUS = 16.0;
    private double sentinelRadius;
    protected final ServerPlayer caster;
    protected final InteractionHand castingHand;

    protected PlayerBasedCastEnv(ServerPlayer caster, InteractionHand castingHand) {
        super(caster.serverLevel());
        this.caster = caster;
        this.castingHand = castingHand;
        this.ambitRadius = caster.getAttributeValue(HexAttributes.AMBIT_RADIUS);
        this.sentinelRadius = caster.getAttributeValue(HexAttributes.SENTINEL_RADIUS);
    }

    @Override
    public LivingEntity getCastingEntity() {
        return this.caster;
    }

    @Override
    public ServerPlayer getCaster() {
        return this.caster;
    }

    @Override
    public void postExecution(CastResult result) {
        super.postExecution(result);
        for (OperatorSideEffect sideEffect : result.getSideEffects()) {
            if (!(sideEffect instanceof OperatorSideEffect.DoMishap)) continue;
            OperatorSideEffect.DoMishap doMishap = (OperatorSideEffect.DoMishap)sideEffect;
            this.sendMishapMsgToPlayer(doMishap);
        }
        if (this.caster != null) {
            double sentinelAttribute;
            double ambitAttribute = this.caster.getAttributeValue(HexAttributes.AMBIT_RADIUS);
            if (this.ambitRadius != ambitAttribute) {
                this.ambitRadius = ambitAttribute;
            }
            if (this.sentinelRadius != (sentinelAttribute = this.caster.getAttributeValue(HexAttributes.SENTINEL_RADIUS))) {
                this.sentinelRadius = sentinelAttribute;
            }
        }
    }

    @Override
    protected List<ItemStack> getUsableStacks(CastingEnvironment.StackDiscoveryMode mode) {
        return this.getUsableStacksForPlayer(mode, this.castingHand, this.caster);
    }

    @Override
    protected List<CastingEnvironment.HeldItemInfo> getPrimaryStacks() {
        return this.getPrimaryStacksForPlayer(this.castingHand, this.caster);
    }

    public double getAmbitRadius() {
        return this.ambitRadius;
    }

    public double getSentinelRadius() {
        return this.sentinelRadius;
    }

    @Override
    public boolean replaceItem(Predicate<ItemStack> stackOk, ItemStack replaceWith, @Nullable InteractionHand hand) {
        return this.replaceItemForPlayer(stackOk, replaceWith, hand, this.caster);
    }

    @Override
    public boolean isVecInRangeEnvironment(Vec3 vec) {
        Sentinel sentinel = HexAPI.instance().getSentinel(this.caster);
        if (sentinel != null && sentinel.extendsRange() && this.caster.level().dimension() == sentinel.dimension() && vec.distanceToSqr(sentinel.position()) <= this.sentinelRadius * this.sentinelRadius + 1.0E-11) {
            return true;
        }
        return vec.distanceToSqr(this.caster.position()) <= this.ambitRadius * this.ambitRadius + 1.0E-11;
    }

    @Override
    public boolean hasEditPermissionsAtEnvironment(BlockPos pos) {
        return this.caster.gameMode.getGameModeForPlayer() != GameType.ADVENTURE && this.world.mayInteract((Player)this.caster, pos);
    }

    protected long extractMediaFromInventory(long costLeft, boolean allowOvercast, boolean simulate) {
        ADMediaHolder source;
        long found;
        List<ADMediaHolder> sources = MediaHelper.scanPlayerForMediaStuff(this.caster);
        long startCost = costLeft;
        Iterator<ADMediaHolder> iterator = sources.iterator();
        while (iterator.hasNext() && (costLeft -= (found = MediaHelper.extractMedia(source = iterator.next(), costLeft, false, simulate))) > 0L) {
        }
        if (costLeft > 0L && allowOvercast) {
            double mediaToHealth = HexConfig.common().mediaToHealthRate();
            double healthToRemove = Math.max((double)costLeft / mediaToHealth, 0.5);
            if (simulate) {
                long simulatedRemovedMedia = Mth.ceil((double)(Math.min((double)this.caster.getHealth(), healthToRemove) * mediaToHealth));
                if (this.caster.isInvulnerableTo(this.caster.damageSources().source(HexDamageTypes.OVERCAST))) {
                    simulatedRemovedMedia = 0L;
                }
                costLeft -= simulatedRemovedMedia;
            } else {
                double mediaAbleToCastFromHP = (double)this.caster.getHealth() * mediaToHealth;
                Mishap.trulyHurt((LivingEntity)this.caster, this.caster.damageSources().source(HexDamageTypes.OVERCAST), (float)healthToRemove);
                int actuallyTaken = Mth.ceil((double)(mediaAbleToCastFromHP - (double)this.caster.getHealth() * mediaToHealth));
                HexAdvancementTriggers.OVERCAST_TRIGGER.trigger(this.caster, actuallyTaken);
                this.caster.awardStat(HexStatistics.MEDIA_OVERCAST, actuallyTaken);
                costLeft -= (long)actuallyTaken;
            }
        }
        if (!simulate) {
            this.caster.awardStat(HexStatistics.MEDIA_USED, (int)(startCost - costLeft));
            HexAdvancementTriggers.SPEND_MEDIA_TRIGGER.trigger(this.caster, startCost - costLeft, costLeft < 0L ? -costLeft : 0L);
        }
        return costLeft;
    }

    protected boolean canOvercast() {
        Advancement adv = this.world.getServer().getAdvancements().getAdvancement(HexAPI.modLoc("y_u_no_cast_angy"));
        PlayerAdvancements advs = this.caster.getAdvancements();
        return advs.getOrStartProgress(adv).isDone();
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        return IXplatAbstractions.INSTANCE.setPigment((Player)this.caster, pigment);
    }

    @Override
    public void produceParticles(ParticleSpray particles, FrozenPigment pigment) {
        particles.sprayParticles(this.world, pigment);
    }

    @Override
    public Vec3 mishapSprayPos() {
        return this.caster.position();
    }

    @Override
    public MishapEnvironment getMishapEnvironment() {
        return new PlayerBasedMishapEnv(this.caster);
    }

    protected void sendMishapMsgToPlayer(OperatorSideEffect.DoMishap mishap) {
        Component msg = mishap.getMishap().errorMessageWithName(this, mishap.getErrorCtx());
        if (msg != null) {
            this.caster.sendSystemMessage(msg);
        }
    }

    @Override
    protected boolean isCreativeMode() {
        return this.caster.getAbilities().instabuild;
    }

    @Override
    public void printMessage(Component message) {
        this.caster.sendSystemMessage(message);
    }
}

