/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.advancements;

import at.petrak.hexcasting.api.mod.HexConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class OvercastTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("hexcasting", "overcast");
    private static final String TAG_MEDIA_GENERATED = "media_generated";
    private static final String TAG_HEALTH_USED = "health_used";
    private static final String TAG_HEALTH_LEFT = "mojang_i_am_begging_and_crying_please_add_an_entity_health_criterion";

    public ResourceLocation getId() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext pContext) {
        return new Instance(predicate, MinMaxBounds.Ints.fromJson((JsonElement)json.get(TAG_MEDIA_GENERATED)), MinMaxBounds.Doubles.fromJson((JsonElement)json.get(TAG_HEALTH_USED)), MinMaxBounds.Doubles.fromJson((JsonElement)json.get(TAG_HEALTH_LEFT)));
    }

    public void trigger(ServerPlayer player, int mediaGenerated) {
        super.trigger(player, inst -> {
            double mediaToHealth = HexConfig.common().mediaToHealthRate();
            double healthUsed = (double)mediaGenerated / mediaToHealth;
            return inst.test(mediaGenerated, healthUsed / (double)player.getMaxHealth(), player.getHealth());
        });
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxBounds.Ints mediaGenerated;
        protected final MinMaxBounds.Doubles healthUsed;
        protected final MinMaxBounds.Doubles healthLeft;

        public Instance(ContextAwarePredicate predicate, MinMaxBounds.Ints mediaGenerated, MinMaxBounds.Doubles healthUsed, MinMaxBounds.Doubles healthLeft) {
            super(ID, predicate);
            this.mediaGenerated = mediaGenerated;
            this.healthUsed = healthUsed;
            this.healthLeft = healthLeft;
        }

        public ResourceLocation getCriterion() {
            return ID;
        }

        public JsonObject serializeToJson(SerializationContext ctx) {
            JsonObject json = super.serializeToJson(ctx);
            if (!this.mediaGenerated.isAny()) {
                json.add(OvercastTrigger.TAG_MEDIA_GENERATED, this.mediaGenerated.serializeToJson());
            }
            if (!this.healthUsed.isAny()) {
                json.add(OvercastTrigger.TAG_HEALTH_USED, this.healthUsed.serializeToJson());
            }
            if (!this.healthLeft.isAny()) {
                json.add(OvercastTrigger.TAG_HEALTH_LEFT, this.healthLeft.serializeToJson());
            }
            return json;
        }

        private boolean test(int mediaGeneratedIn, double healthUsedIn, float healthLeftIn) {
            return this.mediaGenerated.matches(mediaGeneratedIn) && this.healthUsed.matches(healthUsedIn) && this.healthLeft.matches((double)healthLeftIn);
        }
    }
}

