/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.server;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.math.EulerPathFinder;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class ScrungledPatternsSave
extends SavedData {
    public static final String DATA_VERSION = "0.1.0";
    public static final String TAG_SAVED_DATA = "hexcasting.per-world-patterns.0.1.0";
    private static final String TAG_DIR = "startDir";
    private static final String TAG_KEY = "key";
    private final Map<String, PerWorldEntry> lookup;
    private final Map<ResourceKey<ActionRegistryEntry>, String> reverseLookup;

    private ScrungledPatternsSave(Map<String, PerWorldEntry> lookup) {
        this.lookup = lookup;
        this.reverseLookup = new HashMap<ResourceKey<ActionRegistryEntry>, String>();
        this.lookup.forEach((sig, entry) -> this.reverseLookup.put(entry.key, (String)sig));
    }

    @Nullable
    public PerWorldEntry lookup(String signature) {
        return this.lookup.get(signature);
    }

    @Nullable
    public Pair<String, PerWorldEntry> lookupReverse(ResourceKey<ActionRegistryEntry> key) {
        String sig = this.reverseLookup.get(key);
        if (sig == null) {
            return null;
        }
        return Pair.of((Object)sig, (Object)this.lookup.get(sig));
    }

    public CompoundTag save(CompoundTag tag) {
        this.lookup.forEach((sig, entry) -> {
            CompoundTag inner = new CompoundTag();
            inner.putByte(TAG_DIR, (byte)entry.canonicalStartDir.ordinal());
            inner.putString(TAG_KEY, entry.key().location().toString());
            tag.put(sig, (Tag)inner);
        });
        return tag;
    }

    private static ScrungledPatternsSave load(CompoundTag tag) {
        ResourceKey registryKey = IXplatAbstractions.INSTANCE.getActionRegistry().key();
        HashMap<String, PerWorldEntry> map = new HashMap<String, PerWorldEntry>();
        for (String sig : tag.getAllKeys()) {
            CompoundTag inner = tag.getCompound(sig);
            byte rawDir = inner.getByte(TAG_DIR);
            String rawKey = inner.getString(TAG_KEY);
            HexDir dir = HexDir.values()[rawDir];
            ResourceKey key = ResourceKey.create((ResourceKey)registryKey, (ResourceLocation)new ResourceLocation(rawKey));
            map.put(sig, new PerWorldEntry((ResourceKey<ActionRegistryEntry>)key, dir));
        }
        return new ScrungledPatternsSave(map);
    }

    public static ScrungledPatternsSave createFromScratch(long seed) {
        HashMap<String, PerWorldEntry> map = new HashMap<String, PerWorldEntry>();
        Registry<ActionRegistryEntry> registry = IXplatAbstractions.INSTANCE.getActionRegistry();
        for (ResourceKey key : registry.registryKeySet()) {
            ActionRegistryEntry entry = (ActionRegistryEntry)registry.get(key);
            if (!HexUtils.isOfTag(registry, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
            HexPattern scrungledPat = EulerPathFinder.findAltDrawing(entry.prototype(), seed);
            map.put(scrungledPat.anglesSignature(), new PerWorldEntry((ResourceKey<ActionRegistryEntry>)key, scrungledPat.getStartDir()));
        }
        ScrungledPatternsSave out = new ScrungledPatternsSave(map);
        out.setDirty();
        return out;
    }

    public static ScrungledPatternsSave open(ServerLevel overworld) {
        return (ScrungledPatternsSave)overworld.getDataStorage().computeIfAbsent(ScrungledPatternsSave::load, () -> ScrungledPatternsSave.createFromScratch(overworld.getSeed()), TAG_SAVED_DATA);
    }

    public record PerWorldEntry(ResourceKey<ActionRegistryEntry> key, HexDir canonicalStartDir) {
    }
}

