/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StateIngredientBlockState
implements StateIngredient {
    private final BlockState state;

    public StateIngredientBlockState(BlockState state) {
        this.state = state;
    }

    @Override
    public boolean test(BlockState blockState) {
        return this.state == blockState;
    }

    @Override
    public BlockState pick(Random random) {
        return this.state;
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = StateIngredientHelper.serializeBlockState(this.state);
        object.addProperty("type", "state");
        return object;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeVarInt(2);
        buffer.writeVarInt(Block.getId((BlockState)this.state));
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        Block block = this.state.getBlock();
        if (block.asItem() == Items.AIR) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new ItemStack((ItemLike)block));
    }

    @Override
    @Nullable
    public List<Component> descriptionTooltip() {
        ImmutableMap map = this.state.getValues();
        if (map.isEmpty()) {
            return StateIngredient.super.descriptionTooltip();
        }
        ArrayList<Component> tooltip = new ArrayList<Component>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            Property key = (Property)entry.getKey();
            String name = key.getName((Comparable)entry.getValue());
            tooltip.add((Component)Component.literal((String)(key.getName() + " = " + name)).withStyle(ChatFormatting.GRAY));
        }
        return tooltip;
    }

    @Override
    public List<BlockState> getDisplayed() {
        return Collections.singletonList(this.state);
    }

    public BlockState getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.state == ((StateIngredientBlockState)o).state;
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    public String toString() {
        return "StateIngredientBlockState{" + this.state + "}";
    }
}

