/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.misc;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public final class PlayerPositionRecorder {
    private static final Map<Player, Vec3> LAST_SECOND_POSITION_MAP = new WeakHashMap<Player, Vec3>();
    private static final Map<Player, Vec3> LAST_POSITION_MAP = new WeakHashMap<Player, Vec3>();

    public static void updateAllPlayers(ServerLevel world) {
        for (ServerPlayer player : world.players()) {
            Vec3 prev = LAST_POSITION_MAP.get(player);
            if (prev != null) {
                LAST_SECOND_POSITION_MAP.put((Player)player, prev);
            }
            LAST_POSITION_MAP.put((Player)player, player.position());
        }
    }

    public static Vec3 getMotion(ServerPlayer player) {
        Vec3 vec = LAST_POSITION_MAP.get(player);
        Vec3 prev = LAST_SECOND_POSITION_MAP.get(player);
        if (vec == null) {
            return Vec3.ZERO;
        }
        if (prev == null) {
            return player.position().subtract(vec);
        }
        return vec.subtract(prev);
    }
}

