/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.storage;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.gui.PatternTooltipComponent;
import at.petrak.hexcasting.common.misc.PatternTooltip;
import at.petrak.hexcasting.interop.inline.InlinePatternData;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ItemSlate
extends BlockItem
implements IotaHolderItem {
    public static final ResourceLocation WRITTEN_PRED = HexAPI.modLoc("written");

    public ItemSlate(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public Component getName(ItemStack pStack) {
        String key = "block.hexcasting.slate." + (ItemSlate.hasPattern(pStack) ? "written" : "blank");
        Component patternText = (Component)ItemSlate.getPattern(pStack).map(pat -> Component.literal((String)": ").append(new InlinePatternData((HexPattern)pat).asText(false))).orElse(Component.literal((String)""));
        return Component.translatable((String)key).append(patternText);
    }

    public static Optional<HexPattern> getPattern(ItemStack stack) {
        CompoundTag patTag;
        CompoundTag bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet != null && bet.contains("pattern", 10) && !(patTag = bet.getCompound("pattern")).isEmpty()) {
            HexPattern pattern = HexPattern.fromNBT(patTag);
            return Optional.of(pattern);
        }
        return Optional.empty();
    }

    public static boolean hasPattern(ItemStack stack) {
        return ItemSlate.getPattern(stack).isPresent();
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!ItemSlate.hasPattern(stack)) {
            NBTHelper.remove(stack, "BlockEntityTag");
        }
        return false;
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!ItemSlate.hasPattern(pStack)) {
            NBTHelper.remove(pStack, "BlockEntityTag");
        }
    }

    @Override
    @Nullable
    public CompoundTag readIotaTag(ItemStack stack) {
        CompoundTag bet = NBTHelper.getCompound(stack, "BlockEntityTag");
        if (bet == null || !bet.contains("pattern", 10)) {
            return null;
        }
        CompoundTag patTag = bet.getCompound("pattern");
        if (patTag.isEmpty()) {
            return null;
        }
        CompoundTag out = new CompoundTag();
        out.putString("hexcasting:type", "hexcasting:pattern");
        out.put("hexcasting:data", (Tag)patTag);
        return out;
    }

    @Override
    public boolean writeable(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canWrite(ItemStack stack, Iota datum) {
        return datum instanceof PatternIota || datum == null;
    }

    @Override
    public void writeDatum(ItemStack stack, Iota datum) {
        if (this.canWrite(stack, datum)) {
            if (datum == null) {
                CompoundTag beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.remove("pattern");
                if (beTag.isEmpty()) {
                    NBTHelper.remove(stack, "BlockEntityTag");
                }
            } else if (datum instanceof PatternIota) {
                PatternIota pat = (PatternIota)datum;
                CompoundTag beTag = NBTHelper.getOrCreateCompound(stack, "BlockEntityTag");
                beTag.put("pattern", (Tag)pat.getPattern().serializeToNBT());
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return ItemSlate.getPattern(stack).map(pat -> new PatternTooltip((HexPattern)pat, PatternTooltipComponent.SLATE_BG));
    }
}

