/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.env.PackagedItemCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.msgs.MsgNewSpiralPatternsS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ItemPackagedHex
extends ItemMediaHolder
implements HexHolderItem {
    public static final String TAG_PROGRAM = "patterns";
    public static final String TAG_PIGMENT = "pigment";
    public static final ResourceLocation HAS_PATTERNS_PRED = HexAPI.modLoc("has_patterns");

    public ItemPackagedHex(Item.Properties pProperties) {
        super(pProperties);
    }

    public abstract boolean breakAfterDepletion();

    public abstract int cooldown();

    @Override
    public boolean canRecharge(ItemStack stack) {
        return !this.breakAfterDepletion();
    }

    @Override
    public boolean canProvideMedia(ItemStack stack) {
        return false;
    }

    @Override
    public boolean hasHex(ItemStack stack) {
        return NBTHelper.hasList(stack, TAG_PROGRAM, (byte)10);
    }

    @Override
    @Nullable
    public List<Iota> getHex(ItemStack stack, ServerLevel level) {
        ListTag patsTag = NBTHelper.getList(stack, TAG_PROGRAM, 10);
        if (patsTag == null) {
            return null;
        }
        ArrayList<Iota> out = new ArrayList<Iota>();
        for (Tag patTag : patsTag) {
            CompoundTag tag = NBTHelper.getAsCompound(patTag);
            out.add(IotaType.deserialize(tag, level));
        }
        return out;
    }

    @Override
    public void writeHex(ItemStack stack, List<Iota> program, @Nullable FrozenPigment pigment, long media) {
        ListTag patsTag = new ListTag();
        for (Iota pat : program) {
            patsTag.add((Object)IotaType.serialize(pat));
        }
        NBTHelper.putList(stack, TAG_PROGRAM, patsTag);
        if (pigment != null) {
            NBTHelper.putCompound(stack, TAG_PIGMENT, pigment.serializeToNBT());
        }
        ItemPackagedHex.withMedia(stack, media, media);
    }

    @Override
    public void clearHex(ItemStack stack) {
        NBTHelper.remove(stack, TAG_PROGRAM);
        NBTHelper.remove(stack, TAG_PIGMENT);
        NBTHelper.remove(stack, "hexcasting:media");
        NBTHelper.remove(stack, "hexcasting:start_media");
    }

    @Override
    @Nullable
    public FrozenPigment getPigment(ItemStack stack) {
        CompoundTag ctag = NBTHelper.getCompound(stack, TAG_PIGMENT);
        if (ctag == null) {
            return null;
        }
        return FrozenPigment.fromNBT(ctag);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand usedHand) {
        SoundEvent sound;
        ItemStack stack = player.getItemInHand(usedHand);
        if (!this.hasHex(stack)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        List<Iota> instrs = this.getHex(stack, (ServerLevel)world);
        if (instrs == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        PackagedItemCastEnv ctx = new PackagedItemCastEnv(sPlayer, usedHand);
        CastingVM harness = CastingVM.empty(ctx);
        ExecutionClientView clientView = harness.queueExecuteAndWrapIotas(instrs, sPlayer.serverLevel());
        List<HexPattern> patterns = instrs.stream().filter(i -> i instanceof PatternIota).map(i -> ((PatternIota)i).getPattern()).toList();
        MsgNewSpiralPatternsS2C packet = new MsgNewSpiralPatternsS2C(sPlayer.getUUID(), patterns, 140);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(sPlayer, packet);
        IXplatAbstractions.INSTANCE.sendPacketTracking((Entity)sPlayer, packet);
        boolean broken = this.breakAfterDepletion() && this.getMedia(stack) == 0L;
        Stat stat = broken ? Stats.ITEM_BROKEN.get((Object)this) : Stats.ITEM_USED.get((Object)this);
        player.awardStat(stat);
        sPlayer.getCooldowns().addCooldown((Item)this, this.cooldown());
        if (clientView.getResolutionType().getSuccess()) {
            new ParticleSpray(player.position(), new Vec3(0.0, 1.5, 0.0), 0.4, 1.0471975511965976, 30).sprayParticles(sPlayer.serverLevel(), ctx.getPigment());
        }
        if ((sound = ctx.getSound().sound()) != null) {
            Vec3 soundPos = sPlayer.position();
            sPlayer.level().playSound(null, soundPos.x, soundPos.y, soundPos.z, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (broken) {
            stack.shrink(1);
            player.broadcastBreakEvent(usedHand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BLOCK;
    }
}

