/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.lib.HexSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemLoreFragment
extends Item {
    public static final List<ResourceLocation> NAMES = List.of(new ResourceLocation[]{HexAPI.modLoc("lore/cardamom1"), HexAPI.modLoc("lore/cardamom2"), HexAPI.modLoc("lore/cardamom3"), HexAPI.modLoc("lore/cardamom4"), HexAPI.modLoc("lore/cardamom5"), HexAPI.modLoc("lore/experiment1"), HexAPI.modLoc("lore/experiment2"), HexAPI.modLoc("lore/inventory")});
    public static final String CRITEREON_KEY = "grant";

    public ItemLoreFragment(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.playSound(HexSounds.READ_LORE_FRAGMENT, 1.0f, 1.0f);
        ItemStack handStack = player.getItemInHand(usedHand);
        if (!(player instanceof ServerPlayer)) {
            handStack.shrink(1);
            return InteractionResultHolder.success((Object)handStack);
        }
        ServerPlayer splayer = (ServerPlayer)player;
        Advancement unfoundLore = null;
        ArrayList<ResourceLocation> shuffled = new ArrayList<ResourceLocation>(NAMES);
        Collections.shuffle(shuffled);
        for (ResourceLocation advID : shuffled) {
            Advancement adv = splayer.server.getAdvancements().getAdvancement(advID);
            if (adv == null || splayer.getAdvancements().getOrStartProgress(adv).isDone()) continue;
            unfoundLore = adv;
            break;
        }
        if (unfoundLore == null) {
            splayer.displayClientMessage((Component)Component.translatable((String)"item.hexcasting.lore_fragment.all"), true);
            splayer.giveExperiencePoints(20);
            level.playSound(null, player.position().x, player.position().y, player.position().z, HexSounds.READ_LORE_FRAGMENT, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            splayer.getAdvancements().award(unfoundLore, CRITEREON_KEY);
        }
        CriteriaTriggers.CONSUME_ITEM.trigger(splayer, handStack);
        splayer.awardStat(Stats.ITEM_USED.get((Object)this));
        handStack.shrink(1);
        return InteractionResultHolder.success((Object)handStack);
    }
}

