/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBinary;
import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorUnary;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.iota.BooleanIota;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.arithmetic.DoubleArithmetic;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import it.unimi.dsi.fastutil.booleans.BooleanBinaryOperator;
import it.unimi.dsi.fastutil.booleans.BooleanUnaryOperator;
import java.util.List;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0016H\u0002J\"\u0010\u0017\u001a\u00020\u00152\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0002J\u0016\u0010\u001b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lat/petrak/hexcasting/common/casting/arithmetic/BoolArithmetic;", "Lat/petrak/hexcasting/api/casting/arithmetic/Arithmetic;", "()V", "ALL_BOOLS", "Lat/petrak/hexcasting/api/casting/arithmetic/predicates/IotaMultiPredicate;", "getALL_BOOLS", "()Lat/petrak/hexcasting/api/casting/arithmetic/predicates/IotaMultiPredicate;", "OPS", "", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "kotlin.jvm.PlatformType", "arithName", "", "getOperator", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/Operator;", "pattern", "make1", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorUnary;", "op", "Lit/unimi/dsi/fastutil/booleans/BooleanUnaryOperator;", "make2", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBinary;", "Lit/unimi/dsi/fastutil/booleans/BooleanBinaryOperator;", "makeComp", "Ljava/util/function/BiFunction;", "", "", "opTypes", "hexcasting-common-1.20.1"})
public final class BoolArithmetic
implements Arithmetic {
    @NotNull
    public static final BoolArithmetic INSTANCE = new BoolArithmetic();
    @NotNull
    private static final List<HexPattern> OPS;
    @NotNull
    private static final IotaMultiPredicate ALL_BOOLS;

    private BoolArithmetic() {
    }

    @Override
    @NotNull
    public String arithName() {
        return "bool_math";
    }

    @NotNull
    public List<HexPattern> opTypes() {
        return OPS;
    }

    @Override
    @NotNull
    public Operator getOperator(@NotNull HexPattern pattern) {
        Operator operator;
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        HexPattern hexPattern = pattern;
        if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.AND)) {
            operator = this.make2(BoolArithmetic::getOperator$lambda$0);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.OR)) {
            operator = this.make2(BoolArithmetic::getOperator$lambda$1);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.XOR)) {
            operator = this.make2(BoolArithmetic::getOperator$lambda$2);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.GREATER)) {
            operator = this.makeComp(BoolArithmetic::getOperator$lambda$3);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.LESS)) {
            operator = this.makeComp(BoolArithmetic::getOperator$lambda$4);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.GREATER_EQ)) {
            operator = this.makeComp(BoolArithmetic::getOperator$lambda$5);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.LESS_EQ)) {
            operator = this.makeComp(BoolArithmetic::getOperator$lambda$6);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.NOT)) {
            operator = this.make1(BoolArithmetic::getOperator$lambda$7);
        } else if (Intrinsics.areEqual((Object)hexPattern, (Object)Arithmetic.ABS)) {
            operator = new OperatorUnary(ALL_BOOLS, BoolArithmetic::getOperator$lambda$8);
        } else {
            throw new InvalidOperatorException(pattern + " is not a valid operator in Arithmetic " + this + ".");
        }
        return operator;
    }

    @NotNull
    public final IotaMultiPredicate getALL_BOOLS() {
        return ALL_BOOLS;
    }

    private final OperatorUnary make1(BooleanUnaryOperator op) {
        return new OperatorUnary(ALL_BOOLS, arg_0 -> BoolArithmetic.make1$lambda$9(op, arg_0));
    }

    private final OperatorBinary make2(BooleanBinaryOperator op) {
        return new OperatorBinary(ALL_BOOLS, (arg_0, arg_1) -> BoolArithmetic.make2$lambda$10(op, arg_0, arg_1));
    }

    private final OperatorBinary makeComp(BiFunction<Double, Double, Boolean> op) {
        return new OperatorBinary(DoubleArithmetic.INSTANCE.getACCEPTS(), (arg_0, arg_1) -> BoolArithmetic.makeComp$lambda$11(op, arg_0, arg_1));
    }

    private static final boolean getOperator$lambda$0(boolean a, boolean b) {
        return a & b;
    }

    private static final boolean getOperator$lambda$1(boolean a, boolean b) {
        return a | b;
    }

    private static final boolean getOperator$lambda$2(boolean a, boolean b) {
        return a ^ b;
    }

    private static final Boolean getOperator$lambda$3(Double x, Double y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return x > y;
    }

    private static final Boolean getOperator$lambda$4(Double x, Double y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return x < y;
    }

    private static final Boolean getOperator$lambda$5(Double x, Double y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return DoubleIota.tolerates(x, y) || x >= y;
    }

    private static final Boolean getOperator$lambda$6(Double x, Double y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return DoubleIota.tolerates(x, y) || x <= y;
    }

    private static final boolean getOperator$lambda$7(boolean a) {
        return !a;
    }

    private static final Iota getOperator$lambda$8(Iota i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        IotaType<BooleanIota> iotaType = HexIotaTypes.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"BOOLEAN");
        return new DoubleIota(Operator.Companion.downcast(i, iotaType).getBool() ? 1.0 : 0.0);
    }

    private static final Iota make1$lambda$9(BooleanUnaryOperator $op, Iota i) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        IotaType<BooleanIota> iotaType = HexIotaTypes.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"BOOLEAN");
        return new BooleanIota($op.apply(Operator.Companion.downcast(i, iotaType).getBool()));
    }

    private static final Iota make2$lambda$10(BooleanBinaryOperator $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        IotaType<BooleanIota> iotaType = HexIotaTypes.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"BOOLEAN");
        boolean bl = Operator.Companion.downcast(i, iotaType).getBool();
        IotaType<BooleanIota> iotaType2 = HexIotaTypes.BOOLEAN;
        Intrinsics.checkNotNullExpressionValue(iotaType2, (String)"BOOLEAN");
        return new BooleanIota($op.apply(bl, Operator.Companion.downcast(j, iotaType2).getBool()));
    }

    private static final Iota makeComp$lambda$11(BiFunction $op, Iota i, Iota j) {
        Intrinsics.checkNotNullParameter((Object)$op, (String)"$op");
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Intrinsics.checkNotNullParameter((Object)j, (String)"j");
        IotaType<DoubleIota> iotaType = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType, (String)"DOUBLE");
        Double d = Operator.Companion.downcast(i, iotaType).getDouble();
        IotaType<DoubleIota> iotaType2 = HexIotaTypes.DOUBLE;
        Intrinsics.checkNotNullExpressionValue(iotaType2, (String)"DOUBLE");
        Object r = $op.apply(d, Operator.Companion.downcast(j, iotaType2).getDouble());
        Intrinsics.checkNotNullExpressionValue(r, (String)"op.apply(Operator.downca\u2026wncast(j, DOUBLE).double)");
        return new BooleanIota((Boolean)r);
    }

    static {
        Object[] objectArray = new HexPattern[]{Arithmetic.AND, Arithmetic.OR, Arithmetic.XOR, Arithmetic.GREATER, Arithmetic.LESS, Arithmetic.GREATER_EQ, Arithmetic.LESS_EQ, Arithmetic.NOT, Arithmetic.ABS};
        OPS = CollectionsKt.listOf((Object[])objectArray);
        IotaMultiPredicate iotaMultiPredicate = IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.BOOLEAN));
        Intrinsics.checkNotNullExpressionValue((Object)iotaMultiPredicate, (String)"all(IotaPredicate.ofType(BOOLEAN))");
        ALL_BOOLS = iotaMultiPredicate;
    }
}

