/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells.great;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.AltioraAbility;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/great/OpAltiora;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "GRACE_PERIOD", "", "argc", "getArgc", "()I", "checkAllPlayers", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "checkPlayerCollision", "player", "Lnet/minecraft/server/level/ServerPlayer;", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpAltiora
implements SpellAction {
    @NotNull
    public static final OpAltiora INSTANCE = new OpAltiora();
    private static final int argc = 1;
    private static final int GRACE_PERIOD = 20;

    private OpAltiora() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ServerPlayer target = OperatorUtils.getPlayer(args, 0, this.getArgc());
        env.assertEntityInRange((Entity)target);
        RenderedSpell renderedSpell = new Spell(target);
        Object[] objectArray = new ParticleSpray[2];
        Vec3 vec3 = target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position()");
        objectArray[0] = ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 0.5, 0, 4, null);
        Vec3 vec32 = target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"target.position()");
        objectArray[1] = new ParticleSpray(vec32, new Vec3(0.0, 2.0, 0.0), 0.0, 0.1, 0, 16, null);
        return new SpellAction.Result(renderedSpell, 100000L, CollectionsKt.listOf((Object[])objectArray), 0L, 8, null);
    }

    @JvmStatic
    public static final void checkPlayerCollision(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        AltioraAbility altiora = IXplatAbstractions.INSTANCE.getAltiora((Player)player);
        if (altiora != null) {
            if (altiora.gracePeriod() == 0 && (player.onGround() || player.horizontalCollision)) {
                IXplatAbstractions.INSTANCE.setAltiora((Player)player, null);
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), HexSounds.FLIGHT_FINISH, SoundSource.PLAYERS, 2.0f, 1.0f);
            } else {
                int grace2 = Math.max(altiora.gracePeriod() - 1, 0);
                IXplatAbstractions.INSTANCE.setAltiora((Player)player, new AltioraAbility(grace2));
                if ((double)player.level().random.nextFloat() < 0.02) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), HexSounds.FLIGHT_AMBIENCE, SoundSource.PLAYERS, 0.2f, 1.0f);
                }
                FrozenPigment color = IXplatAbstractions.INSTANCE.getPigment((Player)player);
                Vec3 vec3 = player.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.position()");
                ParticleSpray particleSpray = new ParticleSpray(vec3, new Vec3(0.0, -0.2, 0.0), 0.4, 1.5707963267948966, 3);
                ServerLevel serverLevel = player.serverLevel();
                Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"player.serverLevel()");
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
                particleSpray.sprayParticles(serverLevel, color);
            }
        }
    }

    public final void checkAllPlayers(@NotNull ServerLevel world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        for (ServerPlayer player : world.players()) {
            Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
            OpAltiora.checkPlayerCollision(player);
        }
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/great/OpAltiora$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "target", "Lnet/minecraft/server/level/ServerPlayer;", "(Lnet/minecraft/server/level/ServerPlayer;)V", "getTarget", "()Lnet/minecraft/server/level/ServerPlayer;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final ServerPlayer target;

        public Spell(@NotNull ServerPlayer target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
        }

        @NotNull
        public final ServerPlayer getTarget() {
            return this.target;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.target.push(0.0, 1.5, 0.0);
            this.target.hurtMarked = true;
            IXplatAbstractions.INSTANCE.setAltiora((Player)this.target, new AltioraAbility(GRACE_PERIOD));
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final ServerPlayer component1() {
            return this.target;
        }

        @NotNull
        public final Spell copy(@NotNull ServerPlayer target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(target);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, ServerPlayer serverPlayer, int n, Object object) {
            if ((n & 1) != 0) {
                serverPlayer = spell.target;
            }
            return spell.copy(serverPlayer);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ")";
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual((Object)this.target, (Object)spell.target);
        }
    }
}

