/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "type", "Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "(Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;)V", "argc", "", "getArgc", "()I", "getType", "()Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Companion", "Spell", "Type", "hexcasting-common-1.20.1"})
public final class OpFlight
implements SpellAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    private final int argc;
    private static final double DIST_DANGER_THRESHOLD = 4.0;
    private static final double TIME_DANGER_THRESHOLD = 140.0;

    public OpFlight(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.argc = 2;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @Override
    public int getArgc() {
        return this.argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        ServerPlayer target = OperatorUtils.getPlayer(args, 0, this.getArgc());
        double theArg = OperatorUtils.getPositiveDouble(args, 1, this.getArgc());
        env.assertEntityInRange((Entity)target);
        long cost = MathKt.roundToLong((double)(switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> theArg * (double)10000L;
            case 2 -> theArg * (double)50000L;
            default -> throw new NoWhenBranchMatchedException();
        }));
        RenderedSpell renderedSpell = new Spell(this.type, target, theArg);
        Vec3 vec3 = target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position()");
        return new SpellAction.Result(renderedSpell, cost, CollectionsKt.listOf((Object)new ParticleSpray(vec3, new Vec3(0.0, 2.0, 0.0), 0.0, 0.1, 0, 16, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @JvmStatic
    public static final void tickAllPlayers(@NotNull ServerLevel world) {
        Companion.tickAllPlayers(world);
    }

    @JvmStatic
    public static final void tickDownFlight(@NotNull ServerPlayer player) {
        Companion.tickDownFlight(player);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "", "(Ljava/lang/String;I)V", "LimitRange", "LimitTime", "hexcasting-common-1.20.1"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LimitRange = new Type();
        public static final /* enum */ Type LimitTime = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.LimitRange, Type.LimitTime};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "type", "Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "target", "Lnet/minecraft/server/level/ServerPlayer;", "theArg", "", "(Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;Lnet/minecraft/server/level/ServerPlayer;D)V", "getTarget", "()Lnet/minecraft/server/level/ServerPlayer;", "getTheArg", "()D", "getType", "()Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    public static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Type type;
        @NotNull
        private final ServerPlayer target;
        private final double theArg;

        public Spell(@NotNull Type type, @NotNull ServerPlayer target, double theArg) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.type = type;
            this.target = target;
            this.theArg = theArg;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @NotNull
        public final ServerPlayer getTarget() {
            return this.target;
        }

        public final double getTheArg() {
            return this.theArg;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (this.target.getAbilities().mayfly) {
                return;
            }
            ResourceKey dim = this.target.level().dimension();
            Vec3 origin = this.target.position();
            FlightAbility flight = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> new FlightAbility(-1, (ResourceKey<Level>)dim, origin, this.theArg);
                case 2 -> new FlightAbility(MathKt.roundToInt((double)(this.theArg * 20.0)), (ResourceKey<Level>)dim, origin, -1.0);
                default -> throw new NoWhenBranchMatchedException();
            };
            IXplatAbstractions.INSTANCE.setFlight(this.target, flight);
            this.target.getAbilities().mayfly = true;
            this.target.onUpdateAbilities();
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Type component1() {
            return this.type;
        }

        @NotNull
        public final ServerPlayer component2() {
            return this.target;
        }

        public final double component3() {
            return this.theArg;
        }

        @NotNull
        public final Spell copy(@NotNull Type type, @NotNull ServerPlayer target, double theArg) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(type, target, theArg);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Type type, ServerPlayer serverPlayer, double d, int n, Object object) {
            if ((n & 1) != 0) {
                type = spell.type;
            }
            if ((n & 2) != 0) {
                serverPlayer = spell.target;
            }
            if ((n & 4) != 0) {
                d = spell.theArg;
            }
            return spell.copy(type, serverPlayer, d);
        }

        @NotNull
        public String toString() {
            return "Spell(type=" + this.type + ", target=" + this.target + ", theArg=" + this.theArg + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.target.hashCode();
            result = result * 31 + Double.hashCode(this.theArg);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (this.type != spell.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            return Double.compare(this.theArg, spell.theArg) == 0;
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                try {
                    nArray[Type.LimitRange.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.LimitTime.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Companion;", "", "()V", "DIST_DANGER_THRESHOLD", "", "TIME_DANGER_THRESHOLD", "getDanger", "player", "Lnet/minecraft/server/level/ServerPlayer;", "flight", "Lat/petrak/hexcasting/api/player/FlightAbility;", "tickAllPlayers", "", "world", "Lnet/minecraft/server/level/ServerLevel;", "tickDownFlight", "hexcasting-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void tickAllPlayers(@NotNull ServerLevel world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            for (ServerPlayer player : world.players()) {
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                this.tickDownFlight(player);
            }
        }

        @JvmStatic
        public final void tickDownFlight(@NotNull ServerPlayer player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            FlightAbility flight = IXplatAbstractions.INSTANCE.getFlight(player);
            if (flight != null) {
                double danger = this.getDanger(player, flight);
                if (danger >= 1.0) {
                    IXplatAbstractions.INSTANCE.setFlight(player, null);
                    if (!player.isCreative() && !player.isSpectator()) {
                        Abilities abilities = player.getAbilities();
                        abilities.flying = false;
                        abilities.mayfly = false;
                        player.onUpdateAbilities();
                    }
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), HexSounds.FLIGHT_FINISH, SoundSource.PLAYERS, 2.0f, 1.0f);
                    Vec3 vec3 = player.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.position()");
                    ParticleSpray superDangerSpray = new ParticleSpray(vec3, new Vec3(0.0, 1.0, 0.0), Math.PI, 0.4, 20);
                    ServerLevel serverLevel = player.serverLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment = HexItems.DYE_PIGMENTS.get(DyeColor.RED);
                    Intrinsics.checkNotNull((Object)itemDyePigment);
                    superDangerSpray.sprayParticles(serverLevel, new FrozenPigment(new ItemStack((ItemLike)itemDyePigment), Util.NIL_UUID));
                    ServerLevel serverLevel2 = player.serverLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment2 = HexItems.DYE_PIGMENTS.get(DyeColor.BLACK);
                    Intrinsics.checkNotNull((Object)itemDyePigment2);
                    superDangerSpray.sprayParticles(serverLevel2, new FrozenPigment(new ItemStack((ItemLike)itemDyePigment2), Util.NIL_UUID));
                } else {
                    if (!player.getAbilities().mayfly) {
                        player.getAbilities().mayfly = true;
                        player.onUpdateAbilities();
                    }
                    int time2 = flight.timeLeft() >= 0 ? flight.timeLeft() - 1 : flight.timeLeft();
                    IXplatAbstractions.INSTANCE.setFlight(player, new FlightAbility(time2, flight.dimension(), flight.origin(), flight.radius()));
                    int particleCount = 5;
                    int dangerParticleCount = MathKt.roundToInt((double)((double)particleCount * danger));
                    int okParticleCount = particleCount - dangerParticleCount;
                    int oneDangerParticleCount = Mth.ceil((double)((double)dangerParticleCount / 2.0));
                    FrozenPigment color = IXplatAbstractions.INSTANCE.getPigment((Player)player);
                    Vec3 vec3 = player.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.position()");
                    ParticleSpray particleSpray = new ParticleSpray(vec3, new Vec3(0.0, -0.6, 0.0), 0.6, 0.9424777960769379, okParticleCount);
                    ServerLevel serverLevel = player.serverLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"player.serverLevel()");
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
                    particleSpray.sprayParticles(serverLevel, color);
                    Vec3 vec32 = player.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"player.position()");
                    ParticleSpray dangerSpray = new ParticleSpray(vec32, new Vec3(0.0, 1.0, 0.0), 0.3, 2.356194490192345, 0);
                    ParticleSpray particleSpray2 = ParticleSpray.copy$default(dangerSpray, null, null, 0.0, 0.0, oneDangerParticleCount, 15, null);
                    ServerLevel serverLevel3 = player.serverLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel3, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment = HexItems.DYE_PIGMENTS.get(DyeColor.BLACK);
                    Intrinsics.checkNotNull((Object)itemDyePigment);
                    particleSpray2.sprayParticles(serverLevel3, new FrozenPigment(new ItemStack((ItemLike)itemDyePigment), Util.NIL_UUID));
                    ParticleSpray particleSpray3 = ParticleSpray.copy$default(dangerSpray, null, null, 0.0, 0.0, oneDangerParticleCount, 15, null);
                    ServerLevel serverLevel4 = player.serverLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)serverLevel4, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment3 = HexItems.DYE_PIGMENTS.get(DyeColor.RED);
                    Intrinsics.checkNotNull((Object)itemDyePigment3);
                    particleSpray3.sprayParticles(serverLevel4, new FrozenPigment(new ItemStack((ItemLike)itemDyePigment3), Util.NIL_UUID));
                    if ((double)player.level().random.nextFloat() < 0.02) {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), HexSounds.FLIGHT_AMBIENCE, SoundSource.PLAYERS, 0.2f, 1.0f);
                    }
                    if (flight.radius() >= 0.0) {
                        Vec3 spoofedOrigin = flight.origin().add(0.0, 1.0, 0.0);
                        Intrinsics.checkNotNullExpressionValue((Object)spoofedOrigin, (String)"spoofedOrigin");
                        ParticleSpray particleSpray4 = new ParticleSpray(spoofedOrigin, new Vec3(0.0, 1.0, 0.0), 0.5, 0.3141592653589793, 5);
                        ServerLevel serverLevel5 = player.serverLevel();
                        Intrinsics.checkNotNullExpressionValue((Object)serverLevel5, (String)"player.serverLevel()");
                        particleSpray4.sprayParticles(serverLevel5, color);
                        ParticleSpray particleSpray5 = new ParticleSpray(spoofedOrigin, new Vec3(0.0, -1.0, 0.0), 1.5, 0.7853981633974483, 5);
                        ServerLevel serverLevel6 = player.serverLevel();
                        Intrinsics.checkNotNullExpressionValue((Object)serverLevel6, (String)"player.serverLevel()");
                        particleSpray5.sprayParticles(serverLevel6, color);
                    }
                }
            }
        }

        private final double getDanger(ServerPlayer player, FlightAbility flight) {
            double d;
            double radiusDanger;
            if (flight.radius() >= 0.0) {
                if (!Intrinsics.areEqual((Object)player.level().dimension(), flight.dimension())) {
                    v0 = 1.0;
                } else {
                    Vec3 posXZ = new Vec3(player.getX(), 0.0, player.getZ());
                    Vec3 originXZ = new Vec3(flight.origin().x, 0.0, flight.origin().z);
                    double dist = posXZ.distanceTo(originXZ);
                    double distFromEdge = flight.radius() - dist;
                    v0 = distFromEdge >= DIST_DANGER_THRESHOLD ? 0.0 : (dist > flight.radius() ? 1.0 : 1.0 - distFromEdge / DIST_DANGER_THRESHOLD);
                }
            } else {
                v0 = radiusDanger = 0.0;
            }
            if (flight.timeLeft() >= 0) {
                if ((double)flight.timeLeft() >= TIME_DANGER_THRESHOLD) {
                    d = 0.0;
                } else {
                    double timeDanger = TIME_DANGER_THRESHOLD - (double)flight.timeLeft();
                    d = timeDanger / TIME_DANGER_THRESHOLD;
                }
            } else {
                d = 0.0;
            }
            double timeDanger = d;
            return Math.max(radiusDanger, timeDanger);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.LimitRange.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LimitTime.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

