/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.common.casting.actions.spells.OpDestroyFluid;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpDestroyFluid;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "MAX_DESTROY_COUNT", "", "argc", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpDestroyFluid
implements SpellAction {
    @NotNull
    public static final OpDestroyFluid INSTANCE = new OpDestroyFluid();
    private static final int argc = 1;
    public static final int MAX_DESTROY_COUNT = 1024;

    private OpDestroyFluid() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 vecPos = OperatorUtils.getVec3(args, 0, this.getArgc());
        BlockPos pos = BlockPos.containing((Position)((Position)vecPos));
        env.assertPosInRangeForEditing(pos);
        Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
        RenderedSpell renderedSpell = new Spell(pos);
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return new SpellAction.Result(renderedSpell, 200000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst$default(ParticleSpray.Companion, vec3, 3.0, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpDestroyFluid$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "basePos", "Lnet/minecraft/core/BlockPos;", "(Lnet/minecraft/core/BlockPos;)V", "getBasePos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos basePos;

        public Spell(@NotNull BlockPos basePos) {
            Intrinsics.checkNotNullParameter((Object)basePos, (String)"basePos");
            this.basePos = basePos;
        }

        @NotNull
        public final BlockPos getBasePos() {
            return this.basePos;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (IXplatAbstractions.INSTANCE.drainAllFluid((Level)env.getWorld(), this.basePos)) {
                return;
            }
            state = env.getWorld().getBlockState(this.basePos);
            if (state.getBlock() instanceof AbstractCauldronBlock && !Intrinsics.areEqual((Object)state.getBlock(), (Object)Blocks.CAULDRON)) {
                env.getWorld().setBlock(this.basePos, Blocks.CAULDRON.defaultBlockState(), 3);
                return;
            }
            todo = new ArrayDeque();
            seen = new HashSet<BlockPos>();
            for (xShift = -2; xShift < 3; ++xShift) {
                for (yShift = -2; yShift < 3; ++yShift) {
                    for (zShift = -2; zShift < 3; ++zShift) {
                        v0 = this.basePos.offset(xShift, yShift, zShift);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"basePos.offset(xShift, yShift, zShift)");
                        todo.add((Object)v0);
                    }
                }
            }
            successes = 0;
            while (((Collection)todo).isEmpty() == false && successes <= 1024) {
                here = (BlockPos)todo.removeFirst();
                if (!env.canEditBlockAt(here) || !seen.add(here) || Intrinsics.areEqual((Object)(fluid = env.getWorld().getFluidState(here)), (Object)Fluids.EMPTY.defaultFluidState())) continue;
                blockstate = env.getWorld().getBlockState(here);
                if (!IXplatAbstractions.INSTANCE.isBreakingAllowed(env.getWorld(), here, blockstate, (Player)((var8_12 = env.getCastingEntity()) instanceof ServerPlayer != false ? (ServerPlayer)var8_12 : null))) continue;
                if (!(blockstate.getBlock() instanceof BucketPickup)) ** GOTO lbl-1000
                v1 = blockstate.getBlock();
                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.BucketPickup");
                if (!((BucketPickup)v1).pickupBlock((LevelAccessor)env.getWorld(), here, blockstate).isEmpty()) {
                    v2 = true;
                } else if (blockstate.getBlock() instanceof LiquidBlock) {
                    env.getWorld().setBlock(here, Blocks.AIR.defaultBlockState(), 3);
                    v2 = true;
                } else if (blockstate.getTags().anyMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, cast$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)cast.success.1.INSTANCE))) {
                    blockentity = blockstate.hasBlockEntity() != false ? env.getWorld().getBlockEntity(here) : null;
                    Block.dropResources((BlockState)blockstate, (LevelAccessor)((LevelAccessor)env.getWorld()), (BlockPos)here, (BlockEntity)blockentity);
                    env.getWorld().setBlock(here, Blocks.AIR.defaultBlockState(), 3);
                    v2 = true;
                } else {
                    v2 = false;
                }
                if (!(success = v2)) continue;
                env.getWorld().sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)here.getX() + 0.5 + Math.random() * 0.4 - 0.2, (double)here.getY() + 0.5 + Math.random() * 0.4 - 0.2, (double)here.getZ() + 0.5 + Math.random() * 0.4 - 0.2, 2, 0.0, 0.05, 0.0, 0.0);
                ++successes;
                for (Direction dir : Direction.values()) {
                    v3 = here.relative(dir);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"here.relative(dir)");
                    todo.add((Object)v3);
                }
            }
            if (successes > 0) {
                env.getWorld().playSound(null, (double)this.basePos.getX() + 0.5, (double)this.basePos.getY() + 0.5, (double)this.basePos.getZ() + 0.5, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 0.95f);
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.basePos;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos basePos) {
            Intrinsics.checkNotNullParameter((Object)basePos, (String)"basePos");
            return new Spell(basePos);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.basePos;
            }
            return spell.copy(blockPos);
        }

        @NotNull
        public String toString() {
            return "Spell(basePos=" + this.basePos + ")";
        }

        public int hashCode() {
            return this.basePos.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual((Object)this.basePos, (Object)spell.basePos);
        }

        private static final boolean cast$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

