/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.decoration;

import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockSconce
extends AmethystBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static VoxelShape AABB_UP = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);
    protected static VoxelShape AABB_DOWN = Block.box((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static VoxelShape AABB_NORTH = Block.box((double)4.0, (double)4.0, (double)15.0, (double)12.0, (double)12.0, (double)16.0);
    protected static VoxelShape AABB_SOUTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)1.0);
    protected static VoxelShape AABB_WEST = Block.box((double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static VoxelShape AABB_EAST = Block.box((double)0.0, (double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)12.0);

    public BlockSconce(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> AABB_UP;
            case Direction.DOWN -> AABB_DOWN;
            case Direction.NORTH -> AABB_NORTH;
            case Direction.EAST -> AABB_EAST;
            case Direction.SOUTH -> AABB_SOUTH;
            case Direction.WEST -> AABB_WEST;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.getLevel().getFluidState(pContext.getClickedPos());
        BlockState blockstate = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace());
        blockstate = (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8));
        return blockstate;
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource rand) {
        if (rand.nextFloat() < 0.8f) {
            double cx = (double)pPos.getX() + 0.5;
            double cy = (double)pPos.getY() + 0.5;
            double cz = (double)pPos.getZ() + 0.5;
            double dX = switch ((Direction)pState.getValue((Property)FACING)) {
                case Direction.EAST -> rand.triangle((double)0.01f, (double)0.05f);
                case Direction.WEST -> rand.triangle((double)-0.01f, (double)-0.05f);
                default -> rand.triangle((double)-0.01f, (double)0.01f);
            };
            double dY = switch ((Direction)pState.getValue((Property)FACING)) {
                case Direction.UP -> rand.triangle((double)0.01f, (double)0.05f);
                case Direction.DOWN -> rand.triangle((double)-0.01f, (double)-0.05f);
                default -> rand.triangle((double)-0.01f, (double)0.01f);
            };
            double dZ = switch ((Direction)pState.getValue((Property)FACING)) {
                case Direction.SOUTH -> rand.triangle((double)0.01f, (double)0.05f);
                case Direction.NORTH -> rand.triangle((double)-0.01f, (double)-0.05f);
                default -> rand.triangle((double)-0.01f, (double)0.01f);
            };
            int[] colors = new int[]{-9482325, -5009677, -3170061, -3170061, -555};
            pLevel.addParticle((ParticleOptions)new ConjureParticleOptions(colors[rand.nextInt(colors.length)]), cx, cy, cz, dX, dY, dZ);
            if (rand.nextFloat() < 0.08f) {
                pLevel.playLocalSound(cx, cy, cz, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, 0.5f + rand.nextFloat() * 1.2f, false);
            }
        }
    }
}

