/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.gui;

import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.ResolvedPatternType;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.client.ShiftScrollListener;
import at.petrak.hexcasting.client.ktxt.ClientAccessorWrappers;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.client.sound.GridSoundInstance;
import at.petrak.hexcasting.common.lib.HexAttributes;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.common.msgs.MsgNewSpellPatternC2S;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 G2\u00020\u0001:\u0002GHB;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bJ\u0006\u0010\"\u001a\u00020 J\b\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020\u001dH\u0014J\b\u0010-\u001a\u00020$H\u0016J \u0010.\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010/\u001a\u00020\fH\u0016J0\u00100\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010/\u001a\u00020\f2\u0006\u00101\u001a\u00020'2\u0006\u00102\u001a\u00020'H\u0016J\u0018\u00103\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0016J \u00104\u001a\u00020$2\u0006\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020'2\u0006\u0010/\u001a\u00020\fH\u0016J \u00107\u001a\u00020$2\u0006\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020'2\u0006\u0010:\u001a\u00020'H\u0016J\b\u0010;\u001a\u00020\u001dH\u0016J\u000e\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020 J\u0016\u0010>\u001a\u00020\u001d2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\fJ(\u0010B\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020D2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\f2\u0006\u0010E\u001a\u00020+H\u0016J\b\u0010F\u001a\u00020\u001dH\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting;", "Lnet/minecraft/client/gui/screens/Screen;", "handOpenedWith", "Lnet/minecraft/world/InteractionHand;", "patterns", "", "Lat/petrak/hexcasting/api/casting/eval/ResolvedPattern;", "cachedStack", "", "Lnet/minecraft/nbt/CompoundTag;", "cachedRavenmind", "parenCount", "", "(Lnet/minecraft/world/InteractionHand;Ljava/util/List;Ljava/util/List;Lnet/minecraft/nbt/CompoundTag;I)V", "ambianceSoundInstance", "Lat/petrak/hexcasting/client/sound/GridSoundInstance;", "drawState", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "parenDescs", "Lnet/minecraft/util/FormattedCharSequence;", "randSrc", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "ravenmind", "stackDescs", "usedSpots", "", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "calculateIotaDisplays", "", "closeForReal", "coordToPx", "Lnet/minecraft/world/phys/Vec2;", "coord", "coordsOffset", "drawEnd", "", "drawMove", "mxOut", "", "myOut", "drawStart", "hexSize", "", "init", "isPauseScreen", "mouseClicked", "pButton", "mouseDragged", "pDragX", "pDragY", "mouseMoved", "mouseReleased", "mx", "my", "mouseScrolled", "pMouseX", "pMouseY", "pDelta", "onClose", "pxToCoord", "px", "recvServerUpdate", "info", "Lat/petrak/hexcasting/api/casting/eval/ExecutionClientView;", "index", "render", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "pPartialTick", "tick", "Companion", "PatternDrawState", "hexcasting-common-1.20.1"})
public final class GuiSpellcasting
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InteractionHand handOpenedWith;
    @NotNull
    private List<ResolvedPattern> patterns;
    @NotNull
    private List<? extends CompoundTag> cachedStack;
    @Nullable
    private CompoundTag cachedRavenmind;
    private int parenCount;
    @NotNull
    private List<? extends FormattedCharSequence> stackDescs;
    @NotNull
    private List<? extends FormattedCharSequence> parenDescs;
    @Nullable
    private FormattedCharSequence ravenmind;
    @NotNull
    private PatternDrawState drawState;
    @NotNull
    private final Set<HexCoord> usedSpots;
    @Nullable
    private GridSoundInstance ambianceSoundInstance;
    private final RandomSource randSrc;
    public static final double LHS_IOTAS_ALLOCATION = 0.7;
    public static final double RHS_IOTAS_ALLOCATION = 0.15;

    public GuiSpellcasting(@NotNull InteractionHand handOpenedWith, @NotNull List<ResolvedPattern> patterns, @NotNull List<? extends CompoundTag> cachedStack, @Nullable CompoundTag cachedRavenmind, int parenCount) {
        Intrinsics.checkNotNullParameter((Object)handOpenedWith, (String)"handOpenedWith");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter(cachedStack, (String)"cachedStack");
        super((Component)HexUtils.getAsTranslatedComponent("gui.hexcasting.spellcasting"));
        this.handOpenedWith = handOpenedWith;
        this.patterns = patterns;
        this.cachedStack = cachedStack;
        this.cachedRavenmind = cachedRavenmind;
        this.parenCount = parenCount;
        this.stackDescs = CollectionsKt.emptyList();
        this.parenDescs = CollectionsKt.emptyList();
        this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
        this.usedSpots = new HashSet();
        this.randSrc = SoundInstance.createUnseededRandom();
        for (ResolvedPattern resolvedPattern : this.patterns) {
            HexPattern pattern = resolvedPattern.component1();
            HexCoord origin = resolvedPattern.component2();
            this.usedSpots.addAll((Collection<HexCoord>)pattern.positions(origin));
        }
        this.calculateIotaDisplays();
    }

    public final void recvServerUpdate(@NotNull ExecutionClientView info, int index) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (info.isStackClear()) {
            Minecraft minecraft = this.minecraft;
            if (minecraft != null) {
                minecraft.setScreen(null);
            }
            return;
        }
        if (info.getResolutionType() == ResolvedPatternType.UNDONE) {
            Object v1;
            block8: {
                Iterable $this$firstOrNull$iv = CollectionsKt.drop((Iterable)CollectionsKt.reversed((Iterable)this.patterns), (int)1);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ResolvedPattern it = (ResolvedPattern)element$iv;
                    boolean bl = false;
                    if (!(it.getType() == ResolvedPatternType.ESCAPED)) continue;
                    v1 = element$iv;
                    break block8;
                }
                v1 = null;
            }
            ResolvedPattern resolvedPattern = v1;
            if (resolvedPattern != null) {
                ResolvedPattern it = resolvedPattern;
                boolean bl = false;
                it.setType(ResolvedPatternType.UNDONE);
            }
            ResolvedPattern resolvedPattern2 = (ResolvedPattern)CollectionsKt.getOrNull(this.patterns, (int)index);
            if (resolvedPattern2 != null) {
                ResolvedPattern it = resolvedPattern2;
                boolean bl = false;
                it.setType(ResolvedPatternType.EVALUATED);
            }
        } else {
            ResolvedPattern resolvedPattern = (ResolvedPattern)CollectionsKt.getOrNull(this.patterns, (int)index);
            if (resolvedPattern != null) {
                ResolvedPattern it = resolvedPattern;
                boolean bl = false;
                it.setType(info.getResolutionType());
            }
        }
        this.cachedStack = info.getStackDescs();
        this.cachedRavenmind = info.getRavenmind();
        this.calculateIotaDisplays();
    }

    /*
     * WARNING - void declaration
     */
    public final void calculateIotaDisplays() {
        FormattedCharSequence formattedCharSequence;
        CompoundTag $this$mapTo$iv$iv;
        void $this$map$iv;
        Minecraft mc = Minecraft.getInstance();
        int width = (int)((double)this.width * 0.7);
        Iterable iterable = this.cachedStack;
        GuiSpellcasting guiSpellcasting = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompoundTag compoundTag = (CompoundTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IotaType.getDisplayWithMaxWidth((CompoundTag)it, width, mc.font));
        }
        guiSpellcasting.stackDescs = CollectionsKt.asReversed((List)((List)destination$iv$iv));
        this.parenDescs = CollectionsKt.emptyList();
        GuiSpellcasting guiSpellcasting2 = this;
        CompoundTag compoundTag = this.cachedRavenmind;
        if (compoundTag != null) {
            void it;
            $this$mapTo$iv$iv = compoundTag;
            guiSpellcasting = guiSpellcasting2;
            boolean bl = false;
            formattedCharSequence = IotaType.getDisplayWithMaxWidth((CompoundTag)it, (int)((double)this.width * 0.15), mc.font);
            guiSpellcasting2 = guiSpellcasting;
        } else {
            formattedCharSequence = null;
        }
        guiSpellcasting2.ravenmind = formattedCharSequence;
    }

    protected void init() {
        Minecraft minecraft = Minecraft.getInstance();
        SoundManager soundManager = minecraft.getSoundManager();
        soundManager.stop(HexSounds.CASTING_AMBIANCE.getLocation(), null);
        LocalPlayer player = minecraft.player;
        if (player != null) {
            GridSoundInstance gridSoundInstance = this.ambianceSoundInstance = new GridSoundInstance((Player)player);
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
            soundManager.play((SoundInstance)gridSoundInstance);
        }
        this.calculateIotaDisplays();
    }

    public void tick() {
        ItemStack heldItem;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && ((heldItem = player.getItemInHand(this.handOpenedWith)).isEmpty() || !heldItem.is(HexTags.Items.STAVES))) {
            this.closeForReal();
        }
    }

    public boolean mouseClicked(double mxOut, double myOut, int pButton) {
        if (super.mouseClicked(mxOut, myOut, pButton)) {
            return true;
        }
        if (HexConfig.client().clickingTogglesDrawing()) {
            return this.drawState instanceof PatternDrawState.BetweenPatterns ? this.drawStart(mxOut, myOut) : this.drawEnd();
        }
        return this.drawStart(mxOut, myOut);
    }

    private final boolean drawStart(double mxOut, double myOut) {
        HexCoord coord;
        double mx = Mth.clamp((double)mxOut, (double)0.0, (double)this.width);
        double my = Mth.clamp((double)myOut, (double)0.0, (double)this.height);
        if (this.drawState instanceof PatternDrawState.BetweenPatterns && !this.usedSpots.contains(coord = this.pxToCoord(new Vec2((float)mx, (float)my)))) {
            this.drawState = new PatternDrawState.JustStarted(coord);
            SoundManager soundManager = Minecraft.getInstance().getSoundManager();
            GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
            double d = gridSoundInstance.getX();
            GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance2));
            double d2 = gridSoundInstance2.getY();
            GridSoundInstance gridSoundInstance3 = this.ambianceSoundInstance;
            Intrinsics.checkNotNull((Object)((Object)gridSoundInstance3));
            soundManager.play((SoundInstance)new SimpleSoundInstance(HexSounds.START_PATTERN, SoundSource.PLAYERS, 0.25f, 1.0f, this.randSrc, d, d2, gridSoundInstance3.getZ()));
        }
        return false;
    }

    public void mouseMoved(double mxOut, double myOut) {
        super.mouseMoved(mxOut, myOut);
        if (HexConfig.client().clickingTogglesDrawing() && !(this.drawState instanceof PatternDrawState.BetweenPatterns)) {
            this.drawMove(mxOut, myOut);
        }
    }

    public boolean mouseDragged(double mxOut, double myOut, int pButton, double pDragX, double pDragY) {
        if (super.mouseDragged(mxOut, myOut, pButton, pDragX, pDragY)) {
            return true;
        }
        if (HexConfig.client().clickingTogglesDrawing()) {
            return false;
        }
        return this.drawMove(mxOut, myOut);
    }

    private final boolean drawMove(double mxOut, double myOut) {
        HexCoord hexCoord;
        double mx = Mth.clamp((double)mxOut, (double)0.0, (double)this.width);
        double my = Mth.clamp((double)myOut, (double)0.0, (double)this.height);
        PatternDrawState patternDrawState = this.drawState;
        if (Intrinsics.areEqual((Object)patternDrawState, (Object)PatternDrawState.BetweenPatterns.INSTANCE)) {
            hexCoord = null;
        } else if (patternDrawState instanceof PatternDrawState.JustStarted) {
            PatternDrawState patternDrawState2 = this.drawState;
            Intrinsics.checkNotNull((Object)patternDrawState2, (String)"null cannot be cast to non-null type at.petrak.hexcasting.client.gui.GuiSpellcasting.PatternDrawState.JustStarted");
            hexCoord = ((PatternDrawState.JustStarted)patternDrawState2).getStart();
        } else if (patternDrawState instanceof PatternDrawState.Drawing) {
            PatternDrawState patternDrawState3 = this.drawState;
            Intrinsics.checkNotNull((Object)patternDrawState3, (String)"null cannot be cast to non-null type at.petrak.hexcasting.client.gui.GuiSpellcasting.PatternDrawState.Drawing");
            hexCoord = ((PatternDrawState.Drawing)patternDrawState3).getCurrent();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        HexCoord anchorCoord = hexCoord;
        if (anchorCoord != null) {
            Vec2 anchor = this.coordToPx(anchorCoord);
            Vec2 mouse = new Vec2((float)mx, (float)my);
            double snapDist = (double)(this.hexSize() * this.hexSize()) * 2.0 * Mth.clamp((double)HexConfig.client().gridSnapThreshold(), (double)0.5, (double)1.0);
            if ((double)anchor.distanceToSqr(mouse) >= snapDist) {
                float f;
                Vec2 delta = mouse.add(anchor.negated());
                float angle = (float)Math.atan2(delta.y, delta.x);
                float f2 = angle / ((float)Math.PI * 2);
                float f3 = f2 % (f = 6.0f);
                float snappedAngle = !(f3 == 0.0f) && !(Math.signum(f3) == Math.signum(f)) ? f3 + f : f3;
                int n = MathKt.roundToInt((float)(snappedAngle * (float)6)) + 1;
                int n2 = 6;
                int n3 = n % n2;
                HexDir newdir = HexDir.values()[n3 + (n2 & ((n3 ^ n2) & (n3 | -n3)) >> 31)];
                HexCoord idealNextLoc = anchorCoord.plus(newdir);
                boolean playSound = false;
                if (!this.usedSpots.contains(idealNextLoc)) {
                    if (this.drawState instanceof PatternDrawState.JustStarted) {
                        HexPattern pat = new HexPattern(newdir, null, 2, null);
                        this.drawState = new PatternDrawState.Drawing(anchorCoord, idealNextLoc, pat);
                        playSound = true;
                    } else if (this.drawState instanceof PatternDrawState.Drawing) {
                        PatternDrawState patternDrawState4 = this.drawState;
                        Intrinsics.checkNotNull((Object)patternDrawState4, (String)"null cannot be cast to non-null type at.petrak.hexcasting.client.gui.GuiSpellcasting.PatternDrawState.Drawing");
                        PatternDrawState.Drawing ds = (PatternDrawState.Drawing)patternDrawState4;
                        HexDir lastDir = ds.getWipPattern().finalDir();
                        if (newdir == lastDir.rotatedBy(HexAngle.BACK)) {
                            if (ds.getWipPattern().getAngles().isEmpty()) {
                                this.drawState = new PatternDrawState.JustStarted(ds.getCurrent().plus(newdir));
                            } else {
                                ds.setCurrent(ds.getCurrent().plus(newdir));
                                CollectionsKt.removeLast(ds.getWipPattern().getAngles());
                            }
                            playSound = true;
                        } else {
                            boolean success2 = ds.getWipPattern().tryAppendDir(newdir);
                            if (success2) {
                                ds.setCurrent(idealNextLoc);
                            }
                            playSound = success2;
                        }
                    }
                }
                if (playSound) {
                    SoundManager soundManager = Minecraft.getInstance().getSoundManager();
                    float f4 = 1.0f + ((float)Math.random() - 0.5f) * 0.1f;
                    GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
                    Intrinsics.checkNotNull((Object)((Object)gridSoundInstance));
                    double d = gridSoundInstance.getX();
                    GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
                    Intrinsics.checkNotNull((Object)((Object)gridSoundInstance2));
                    double d2 = gridSoundInstance2.getY();
                    GridSoundInstance gridSoundInstance3 = this.ambianceSoundInstance;
                    Intrinsics.checkNotNull((Object)((Object)gridSoundInstance3));
                    soundManager.play((SoundInstance)new SimpleSoundInstance(HexSounds.ADD_TO_PATTERN, SoundSource.PLAYERS, 0.25f, f4, this.randSrc, d, d2, gridSoundInstance3.getZ()));
                }
            }
        }
        return false;
    }

    public boolean mouseReleased(double mx, double my, int pButton) {
        if (super.mouseReleased(mx, my, pButton)) {
            return true;
        }
        if (HexConfig.client().clickingTogglesDrawing()) {
            return false;
        }
        return this.drawEnd();
    }

    private final boolean drawEnd() {
        PatternDrawState patternDrawState = this.drawState;
        if (!Intrinsics.areEqual((Object)patternDrawState, (Object)PatternDrawState.BetweenPatterns.INSTANCE)) {
            if (patternDrawState instanceof PatternDrawState.JustStarted) {
                this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
            } else if (patternDrawState instanceof PatternDrawState.Drawing) {
                PatternDrawState patternDrawState2 = this.drawState;
                Intrinsics.checkNotNull((Object)patternDrawState2, (String)"null cannot be cast to non-null type at.petrak.hexcasting.client.gui.GuiSpellcasting.PatternDrawState.Drawing");
                PatternDrawState.Drawing drawing = (PatternDrawState.Drawing)patternDrawState2;
                HexCoord start = drawing.component1();
                HexPattern pat = drawing.component3();
                this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
                this.patterns.add(new ResolvedPattern(pat, start, ResolvedPatternType.UNRESOLVED));
                this.usedSpots.addAll((Collection<HexCoord>)pat.positions(start));
                IClientXplatAbstractions.INSTANCE.sendPacketToServer(new MsgNewSpellPatternC2S(this.handOpenedWith, pat, this.patterns));
            }
        }
        return false;
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        super.mouseScrolled(pMouseX, pMouseY, pDelta);
        MouseHandler mouseHandler = Minecraft.getInstance().mouseHandler;
        Intrinsics.checkNotNullExpressionValue((Object)mouseHandler, (String)"mouseHandler");
        if (!(ClientAccessorWrappers.getAccumulatedScroll(mouseHandler) == 0.0) && !(Math.signum(pDelta) == Math.signum(ClientAccessorWrappers.getAccumulatedScroll(mouseHandler)))) {
            ClientAccessorWrappers.setAccumulatedScroll(mouseHandler, 0.0);
        }
        ClientAccessorWrappers.setAccumulatedScroll(mouseHandler, ClientAccessorWrappers.getAccumulatedScroll(mouseHandler) + pDelta);
        int accumulation = (int)ClientAccessorWrappers.getAccumulatedScroll(mouseHandler);
        if (accumulation == 0) {
            return true;
        }
        ClientAccessorWrappers.setAccumulatedScroll(mouseHandler, ClientAccessorWrappers.getAccumulatedScroll(mouseHandler) - (double)accumulation);
        ShiftScrollListener.onScroll(pDelta, false);
        return true;
    }

    public void onClose() {
        if (Intrinsics.areEqual((Object)this.drawState, (Object)PatternDrawState.BetweenPatterns.INSTANCE)) {
            this.closeForReal();
        } else {
            this.drawState = PatternDrawState.BetweenPatterns.INSTANCE;
        }
    }

    public final void closeForReal() {
        Minecraft.getInstance().getSoundManager().stop(HexSounds.CASTING_AMBIANCE.getLocation(), null);
        super.onClose();
    }

    public void render(@NotNull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        GridSoundInstance gridSoundInstance = this.ambianceSoundInstance;
        if (gridSoundInstance != null) {
            gridSoundInstance.setMousePosX((double)pMouseX / (double)this.width);
        }
        GridSoundInstance gridSoundInstance2 = this.ambianceSoundInstance;
        if (gridSoundInstance2 != null) {
            gridSoundInstance2.setMousePosY((double)pMouseX / (double)this.width);
        }
        PoseStack ps = graphics.pose();
        Matrix4f mat = ps.last().pose();
        ShaderInstance prevShader = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        Vec2 mousePos = new Vec2((float)pMouseX, (float)pMouseY);
        HexCoord mouseCoord = this.pxToCoord(mousePos);
        int radius = 3;
        Iterator<Object> iterator = mouseCoord.rangeAround(radius);
        while (iterator.hasNext()) {
            HexCoord dotCoord = iterator.next();
            if (this.usedSpots.contains(dotCoord)) continue;
            Vec2 dotPx = this.coordToPx(dotCoord);
            float delta = dotPx.add(mousePos.negated()).length();
            float f = Mth.clamp((float)(1.0f - (delta - this.hexSize()) / ((float)radius * this.hexSize())), (float)0.0f, (float)1.0f);
            Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"mat");
            RenderLib.drawSpot(mat, dotPx, f * 2.0f, Mth.lerp((float)f, (float)0.4f, (float)0.5f), Mth.lerp((float)f, (float)0.8f, (float)1.0f), Mth.lerp((float)f, (float)0.7f, (float)0.9f), f);
        }
        RenderSystem.defaultBlendFunc();
        iterator = this.patterns.iterator();
        int dotCoord = 0;
        while (iterator.hasNext()) {
            int idx = dotCoord++;
            ResolvedPattern elts = (ResolvedPattern)iterator.next();
            HexPattern hexPattern = elts.component1();
            HexCoord origin = elts.component2();
            ResolvedPatternType valid = elts.component3();
            Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"mat");
            RenderLib.drawPatternFromPoints(mat, hexPattern.toLines(this.hexSize(), this.coordToPx(origin)), RenderLib.findDupIndices(HexPattern.positions$default(hexPattern, null, 1, null)), true, valid.getColor() | 0xC8000000, valid.getFadeColor() | 0xC8000000, valid.getSuccess() ? 0.2f : 0.9f, 0.2f, 1.0f, idx);
        }
        if (!(this.drawState instanceof PatternDrawState.BetweenPatterns)) {
            List points = new ArrayList();
            Set<Integer> dupIndices = null;
            if (this.drawState instanceof PatternDrawState.JustStarted) {
                PatternDrawState patternDrawState = this.drawState;
                Intrinsics.checkNotNull((Object)patternDrawState, (String)"null cannot be cast to non-null type at.petrak.hexcasting.client.gui.GuiSpellcasting.PatternDrawState.JustStarted");
                PatternDrawState.JustStarted ds = (PatternDrawState.JustStarted)patternDrawState;
                points.add(this.coordToPx(ds.getStart()));
            } else if (this.drawState instanceof PatternDrawState.Drawing) {
                PatternDrawState patternDrawState = this.drawState;
                Intrinsics.checkNotNull((Object)patternDrawState, (String)"null cannot be cast to non-null type at.petrak.hexcasting.client.gui.GuiSpellcasting.PatternDrawState.Drawing");
                PatternDrawState.Drawing ds = (PatternDrawState.Drawing)patternDrawState;
                dupIndices = RenderLib.findDupIndices(HexPattern.positions$default(ds.getWipPattern(), null, 1, null));
                for (HexCoord hexCoord : HexPattern.positions$default(ds.getWipPattern(), null, 1, null)) {
                    Vec2 pix = this.coordToPx(hexCoord.plus(ds.getStart()));
                    points.add(pix);
                }
            }
            points.add(mousePos);
            Intrinsics.checkNotNullExpressionValue((Object)mat, (String)"mat");
            RenderLib.drawPatternFromPoints(mat, points, dupIndices, false, -10172161, -78874, 0.1f, 0.2f, 1.0f, this.patterns.size());
        }
        RenderSystem.enableDepthTest();
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        ps.pushPose();
        ps.translate(10.0, 10.0, 0.0);
        if (!((Collection)this.stackDescs).isEmpty()) {
            float boxHeight = ((float)this.stackDescs.size() + 1.0f) * 10.0f;
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.enableBlend();
            Intrinsics.checkNotNullExpressionValue((Object)ps, (String)"ps");
            at.petrak.hexcasting.client.gui.GuiSpellcasting$Companion.drawBox$default(Companion, ps, 0.0f, 0.0f, (float)((double)this.width * 0.7 + (double)5), boxHeight, 0.0f, 32, null);
            ps.translate(0.0, 0.0, 1.0);
            RenderSystem.setShader(() -> GuiSpellcasting.render$lambda$6(prevShader));
            for (FormattedCharSequence formattedCharSequence : this.stackDescs) {
                graphics.drawString(font, formattedCharSequence, 5, 7, -1);
                ps.translate(0.0, 10.0, 0.0);
            }
        }
        ps.popPose();
        if (this.ravenmind != null) {
            FormattedCharSequence formattedCharSequence = this.ravenmind;
            Intrinsics.checkNotNull((Object)formattedCharSequence);
            FormattedCharSequence kotlinBad = formattedCharSequence;
            ps.pushPose();
            float boxHeight = 15.0f;
            float f = 1.5f;
            ps.translate((double)this.width * (1.0 - 0.15 * (double)f) - (double)10, 10.0, 0.0);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.enableBlend();
            Intrinsics.checkNotNullExpressionValue((Object)ps, (String)"ps");
            at.petrak.hexcasting.client.gui.GuiSpellcasting$Companion.drawBox$default(Companion, ps, 0.0f, 0.0f, (float)((double)this.width * 0.15 * (double)f), boxHeight * f, 0.0f, 32, null);
            ps.translate(5.0, 5.0, 1.0);
            ps.scale(f, f, 1.0f);
            float time = ClientTickCounter.getTotal() * 0.2f;
            int opacity = (int)Mth.map((float)((float)Math.sin(time)), (float)-1.0f, (float)1.0f, (float)150.0f, (float)255.0f);
            int color = 0xFFFFFF | opacity << 24;
            RenderSystem.setShader(() -> GuiSpellcasting.render$lambda$7(prevShader));
            graphics.drawString(font, kotlinBad, 0, 0, color);
            ps.popPose();
        }
        RenderSystem.setShader(() -> GuiSpellcasting.render$lambda$8(prevShader));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public final float hexSize() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Intrinsics.checkNotNull((Object)localPlayer);
        double scaleModifier = localPlayer.getAttributeValue(HexAttributes.GRID_ZOOM);
        double baseScale = Math.sqrt((double)this.width * (double)this.height / 512.0);
        return (float)(baseScale / scaleModifier);
    }

    @NotNull
    public final Vec2 coordsOffset() {
        return new Vec2((float)this.width * 0.5f, (float)this.height * 0.5f);
    }

    @NotNull
    public final Vec2 coordToPx(@NotNull HexCoord coord) {
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        return HexUtils.coordToPx(coord, this.hexSize(), this.coordsOffset());
    }

    @NotNull
    public final HexCoord pxToCoord(@NotNull Vec2 px) {
        Intrinsics.checkNotNullParameter((Object)px, (String)"px");
        return HexUtils.pxToCoord(px, this.hexSize(), this.coordsOffset());
    }

    private static final ShaderInstance render$lambda$6(ShaderInstance $prevShader) {
        return $prevShader;
    }

    private static final ShaderInstance render$lambda$7(ShaderInstance $prevShader) {
        return $prevShader;
    }

    private static final ShaderInstance render$lambda$8(ShaderInstance $prevShader) {
        return $prevShader;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "", "()V", "BetweenPatterns", "Drawing", "JustStarted", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$BetweenPatterns;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$Drawing;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$JustStarted;", "hexcasting-common-1.20.1"})
    private static abstract class PatternDrawState {
        private PatternDrawState() {
        }

        public /* synthetic */ PatternDrawState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$BetweenPatterns;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "()V", "hexcasting-common-1.20.1"})
        public static final class BetweenPatterns
        extends PatternDrawState {
            @NotNull
            public static final BetweenPatterns INSTANCE = new BetweenPatterns();

            private BetweenPatterns() {
                super(null);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$JustStarted;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "start", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;)V", "getStart", "()Lat/petrak/hexcasting/api/casting/math/HexCoord;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
        public static final class JustStarted
        extends PatternDrawState {
            @NotNull
            private final HexCoord start;

            public JustStarted(@NotNull HexCoord start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                super(null);
                this.start = start;
            }

            @NotNull
            public final HexCoord getStart() {
                return this.start;
            }

            @NotNull
            public final HexCoord component1() {
                return this.start;
            }

            @NotNull
            public final JustStarted copy(@NotNull HexCoord start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                return new JustStarted(start);
            }

            public static /* synthetic */ JustStarted copy$default(JustStarted justStarted, HexCoord hexCoord, int n, Object object) {
                if ((n & 1) != 0) {
                    hexCoord = justStarted.start;
                }
                return justStarted.copy(hexCoord);
            }

            @NotNull
            public String toString() {
                return "JustStarted(start=" + this.start + ")";
            }

            public int hashCode() {
                return this.start.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof JustStarted)) {
                    return false;
                }
                JustStarted justStarted = (JustStarted)other;
                return Intrinsics.areEqual((Object)this.start, (Object)justStarted.start);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState$Drawing;", "Lat/petrak/hexcasting/client/gui/GuiSpellcasting$PatternDrawState;", "start", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "current", "wipPattern", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;Lat/petrak/hexcasting/api/casting/math/HexCoord;Lat/petrak/hexcasting/api/casting/math/HexPattern;)V", "getCurrent", "()Lat/petrak/hexcasting/api/casting/math/HexCoord;", "setCurrent", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;)V", "getStart", "getWipPattern", "()Lat/petrak/hexcasting/api/casting/math/HexPattern;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
        public static final class Drawing
        extends PatternDrawState {
            @NotNull
            private final HexCoord start;
            @NotNull
            private HexCoord current;
            @NotNull
            private final HexPattern wipPattern;

            public Drawing(@NotNull HexCoord start, @NotNull HexCoord current, @NotNull HexPattern wipPattern) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Intrinsics.checkNotNullParameter((Object)wipPattern, (String)"wipPattern");
                super(null);
                this.start = start;
                this.current = current;
                this.wipPattern = wipPattern;
            }

            @NotNull
            public final HexCoord getStart() {
                return this.start;
            }

            @NotNull
            public final HexCoord getCurrent() {
                return this.current;
            }

            public final void setCurrent(@NotNull HexCoord hexCoord) {
                Intrinsics.checkNotNullParameter((Object)hexCoord, (String)"<set-?>");
                this.current = hexCoord;
            }

            @NotNull
            public final HexPattern getWipPattern() {
                return this.wipPattern;
            }

            @NotNull
            public final HexCoord component1() {
                return this.start;
            }

            @NotNull
            public final HexCoord component2() {
                return this.current;
            }

            @NotNull
            public final HexPattern component3() {
                return this.wipPattern;
            }

            @NotNull
            public final Drawing copy(@NotNull HexCoord start, @NotNull HexCoord current, @NotNull HexPattern wipPattern) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                Intrinsics.checkNotNullParameter((Object)wipPattern, (String)"wipPattern");
                return new Drawing(start, current, wipPattern);
            }

            public static /* synthetic */ Drawing copy$default(Drawing drawing, HexCoord hexCoord, HexCoord hexCoord2, HexPattern hexPattern, int n, Object object) {
                if ((n & 1) != 0) {
                    hexCoord = drawing.start;
                }
                if ((n & 2) != 0) {
                    hexCoord2 = drawing.current;
                }
                if ((n & 4) != 0) {
                    hexPattern = drawing.wipPattern;
                }
                return drawing.copy(hexCoord, hexCoord2, hexPattern);
            }

            @NotNull
            public String toString() {
                return "Drawing(start=" + this.start + ", current=" + this.current + ", wipPattern=" + this.wipPattern + ")";
            }

            public int hashCode() {
                int result = this.start.hashCode();
                result = result * 31 + this.current.hashCode();
                result = result * 31 + this.wipPattern.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Drawing)) {
                    return false;
                }
                Drawing drawing = (Drawing)other;
                if (!Intrinsics.areEqual((Object)this.start, (Object)drawing.start)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.current, (Object)drawing.current)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.wipPattern, (Object)drawing.wipPattern);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lat/petrak/hexcasting/client/gui/GuiSpellcasting$Companion;", "", "()V", "LHS_IOTAS_ALLOCATION", "", "RHS_IOTAS_ALLOCATION", "drawBox", "", "ps", "Lcom/mojang/blaze3d/vertex/PoseStack;", "x", "", "y", "w", "h", "leftMargin", "hexcasting-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void drawBox(@NotNull PoseStack ps, float x, float y, float w, float h, float leftMargin) {
            Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.enableBlend();
            RenderLib.renderQuad(ps, x, y, w, h, 0x50303030);
            RenderLib.renderQuad(ps, x + leftMargin, y + 2.5f, w - leftMargin - 2.5f, h - 5.0f, 0x50303030);
        }

        public static /* synthetic */ void drawBox$default(Companion companion, PoseStack poseStack, float f, float f2, float f3, float f4, float f5, int n, Object object) {
            if ((n & 0x20) != 0) {
                f5 = 2.5f;
            }
            companion.drawBox(poseStack, f, f2, f3, f4, f5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

