/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.item;

import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.OverrideOnly
public interface MediaHolderItem {
    public long getMedia(ItemStack var1);

    public long getMaxMedia(ItemStack var1);

    public void setMedia(ItemStack var1, long var2);

    public boolean canProvideMedia(ItemStack var1);

    public boolean canRecharge(ItemStack var1);

    default public float getMediaFullness(ItemStack stack) {
        long max = this.getMaxMedia(stack);
        if (max == 0L) {
            return 0.0f;
        }
        return (float)this.getMedia(stack) / (float)max;
    }

    default public long withdrawMedia(ItemStack stack, long cost, boolean simulate) {
        long mediaHere = this.getMedia(stack);
        if (cost < 0L) {
            cost = mediaHere;
        }
        if (!simulate) {
            long mediaLeft = mediaHere - cost;
            this.setMedia(stack, mediaLeft);
        }
        return Math.min(cost, mediaHere);
    }

    default public long insertMedia(ItemStack stack, long amount, boolean simulate) {
        long mediaHere = this.getMedia(stack);
        long emptySpace = this.getMaxMedia(stack) - mediaHere;
        if (emptySpace <= 0L) {
            return 0L;
        }
        if (amount < 0L) {
            amount = emptySpace;
        }
        long inserting = Math.min(amount, emptySpace);
        if (!simulate) {
            long newMedia = mediaHere + inserting;
            this.setMedia(stack, newMedia);
        }
        return inserting;
    }

    default public int getConsumptionPriority(ItemStack stack) {
        return 4000;
    }
}

