/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.circles;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.misc.Result;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.HexUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CircleExecutionState {
    public static final String TAG_IMPETUS_POS = "impetus_pos";
    public static final String TAG_IMPETUS_DIR = "impetus_dir";
    public static final String TAG_KNOWN_POSITIONS = "known_positions";
    public static final String TAG_REACHED_POSITIONS = "reached_positions";
    public static final String TAG_CURRENT_POS = "current_pos";
    public static final String TAG_ENTERED_FROM = "entered_from";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_CASTER = "caster";
    public static final String TAG_PIGMENT = "pigment";
    public final BlockPos impetusPos;
    public final Direction impetusDir;
    public final Set<BlockPos> knownPositions;
    public final List<BlockPos> reachedPositions;
    public BlockPos currentPos;
    public Direction enteredFrom;
    public CastingImage currentImage;
    @Nullable
    public UUID caster;
    @Nullable
    public FrozenPigment casterPigment;
    public final AABB bounds;

    protected CircleExecutionState(BlockPos impetusPos, Direction impetusDir, Set<BlockPos> knownPositions, List<BlockPos> reachedPositions, BlockPos currentPos, Direction enteredFrom, CastingImage currentImage, @Nullable UUID caster, @Nullable FrozenPigment casterPigment) {
        this.impetusPos = impetusPos;
        this.impetusDir = impetusDir;
        this.knownPositions = knownPositions;
        this.reachedPositions = reachedPositions;
        this.currentPos = currentPos;
        this.enteredFrom = enteredFrom;
        this.currentImage = currentImage;
        this.caster = caster;
        this.casterPigment = casterPigment;
        this.bounds = BlockEntityAbstractImpetus.getBounds(new ArrayList<BlockPos>(this.knownPositions));
    }

    @Nullable
    public ServerPlayer getCaster(ServerLevel world) {
        if (this.caster == null) {
            return null;
        }
        Entity entity = world.getEntity(this.caster);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer;
        }
        return null;
    }

    public static Result<CircleExecutionState, @Nullable BlockPos> createNew(BlockEntityAbstractImpetus impetus, @Nullable ServerPlayer caster) {
        UUID casterUUID;
        ServerLevel level = (ServerLevel)impetus.getLevel();
        if (level == null) {
            return new Result.Err(null);
        }
        Stack<Pair> todo = new Stack<Pair>();
        todo.add(Pair.of((Object)impetus.getStartDirection(), (Object)impetus.getBlockPos().relative(impetus.getStartDirection())));
        HashSet<BlockPos> seenGoodPosSet = new HashSet<BlockPos>();
        ArrayList<BlockPos> seenGoodPositions = new ArrayList<BlockPos>();
        while (!todo.isEmpty()) {
            ICircleComponent cmp;
            Pair pair = (Pair)todo.pop();
            Direction enterDir = (Direction)pair.getFirst();
            BlockPos herePos = (BlockPos)pair.getSecond();
            BlockState hereBs = level.getBlockState(herePos);
            Block block = hereBs.getBlock();
            if (!(block instanceof ICircleComponent) || !(cmp = (ICircleComponent)block).canEnterFromDirection(enterDir, herePos, hereBs, level) || !seenGoodPosSet.add(herePos)) continue;
            seenGoodPositions.add(herePos);
            EnumSet<Direction> outs = cmp.possibleExitDirections(herePos, hereBs, (Level)level);
            for (Direction out : outs) {
                todo.add(Pair.of((Object)out, (Object)herePos.relative(out)));
            }
        }
        if (seenGoodPositions.isEmpty()) {
            return new Result.Err(null);
        }
        if (!seenGoodPosSet.contains(impetus.getBlockPos())) {
            return new Result.Err<CircleExecutionState, BlockPos>((BlockPos)seenGoodPositions.get(seenGoodPositions.size() - 1));
        }
        HashSet<BlockPos> knownPositions = new HashSet<BlockPos>(seenGoodPositions);
        ArrayList<BlockPos> reachedPositions = new ArrayList<BlockPos>();
        reachedPositions.add(impetus.getBlockPos());
        BlockPos start = (BlockPos)seenGoodPositions.get(0);
        FrozenPigment colorizer = null;
        if (caster == null) {
            casterUUID = null;
        } else {
            colorizer = HexAPI.instance().getColorizer((Player)caster);
            casterUUID = caster.getUUID();
        }
        return new Result.Ok<CircleExecutionState, BlockPos>(new CircleExecutionState(impetus.getBlockPos(), impetus.getStartDirection(), knownPositions, reachedPositions, start, impetus.getStartDirection(), new CastingImage(), casterUUID, colorizer));
    }

    public CompoundTag save() {
        CompoundTag out = new CompoundTag();
        out.put(TAG_IMPETUS_POS, (Tag)NbtUtils.writeBlockPos((BlockPos)this.impetusPos));
        out.putByte(TAG_IMPETUS_DIR, (byte)this.impetusDir.ordinal());
        ListTag knownTag = new ListTag();
        for (BlockPos bp : this.knownPositions) {
            knownTag.add((Object)NbtUtils.writeBlockPos((BlockPos)bp));
        }
        out.put(TAG_KNOWN_POSITIONS, (Tag)knownTag);
        ListTag reachedTag = new ListTag();
        for (BlockPos bp : this.reachedPositions) {
            reachedTag.add((Object)NbtUtils.writeBlockPos((BlockPos)bp));
        }
        out.put(TAG_REACHED_POSITIONS, (Tag)reachedTag);
        out.put(TAG_CURRENT_POS, (Tag)NbtUtils.writeBlockPos((BlockPos)this.currentPos));
        out.putByte(TAG_ENTERED_FROM, (byte)this.enteredFrom.ordinal());
        out.put(TAG_IMAGE, (Tag)this.currentImage.serializeToNbt());
        if (this.caster != null) {
            out.putUUID(TAG_CASTER, this.caster);
        }
        if (this.casterPigment != null) {
            out.put(TAG_PIGMENT, (Tag)this.casterPigment.serializeToNBT());
        }
        return out;
    }

    public static CircleExecutionState load(CompoundTag nbt, ServerLevel world) {
        BlockPos startPos = NbtUtils.readBlockPos((CompoundTag)nbt.getCompound(TAG_IMPETUS_POS));
        Direction startDir = Direction.values()[nbt.getByte(TAG_IMPETUS_DIR)];
        HashSet<BlockPos> knownPositions = new HashSet<BlockPos>();
        ListTag knownTag = nbt.getList(TAG_KNOWN_POSITIONS, 10);
        for (Tag tag : knownTag) {
            knownPositions.add(NbtUtils.readBlockPos((CompoundTag)((CompoundTag)HexUtils.downcast(tag, CompoundTag.TYPE))));
        }
        ArrayList<BlockPos> reachedPositions = new ArrayList<BlockPos>();
        ListTag reachedTag = nbt.getList(TAG_REACHED_POSITIONS, 10);
        for (Tag tag : reachedTag) {
            reachedPositions.add(NbtUtils.readBlockPos((CompoundTag)((CompoundTag)HexUtils.downcast(tag, CompoundTag.TYPE))));
        }
        BlockPos currentPos = NbtUtils.readBlockPos((CompoundTag)nbt.getCompound(TAG_CURRENT_POS));
        Direction enteredFrom = Direction.values()[nbt.getByte(TAG_ENTERED_FROM)];
        CastingImage image = CastingImage.loadFromNbt(nbt.getCompound(TAG_IMAGE), world);
        UUID caster = null;
        if (nbt.hasUUID(TAG_CASTER)) {
            caster = nbt.getUUID(TAG_CASTER);
        }
        FrozenPigment pigment = null;
        if (nbt.contains(TAG_PIGMENT, 10)) {
            pigment = FrozenPigment.fromNBT(nbt.getCompound(TAG_PIGMENT));
        }
        return new CircleExecutionState(startPos, startDir, knownPositions, reachedPositions, currentPos, enteredFrom, image, caster, pigment);
    }

    public boolean tick(BlockEntityAbstractImpetus impetus) {
        ServerLevel world = (ServerLevel)impetus.getLevel();
        if (world == null) {
            return true;
        }
        CircleCastEnv env = new CircleCastEnv(world, this);
        BlockState executorBlockState = world.getBlockState(this.currentPos);
        Block block = executorBlockState.getBlock();
        if (!(block instanceof ICircleComponent)) {
            ICircleComponent.sfx(this.currentPos, executorBlockState, (Level)world, Objects.requireNonNull(env.getImpetus()), false);
            return false;
        }
        ICircleComponent executor = (ICircleComponent)block;
        executorBlockState = executor.startEnergized(this.currentPos, executorBlockState, (Level)world);
        this.reachedPositions.add(this.currentPos);
        boolean halt = false;
        ICircleComponent.ControlFlow ctrl = executor.acceptControlFlow(this.currentImage, env, this.enteredFrom, this.currentPos, executorBlockState, world);
        if (env.getImpetus() == null) {
            return false;
        }
        if (ctrl instanceof ICircleComponent.ControlFlow.Stop) {
            halt = true;
        } else if (ctrl instanceof ICircleComponent.ControlFlow.Continue) {
            ICircleComponent.ControlFlow.Continue cont = (ICircleComponent.ControlFlow.Continue)ctrl;
            Pair<BlockPos, Direction> found = null;
            for (Pair<BlockPos, Direction> exit : cont.exits) {
                ICircleComponent cc;
                BlockState there = world.getBlockState((BlockPos)exit.getFirst());
                Block block2 = there.getBlock();
                if (!(block2 instanceof ICircleComponent) || !(cc = (ICircleComponent)block2).canEnterFromDirection((Direction)exit.getSecond(), (BlockPos)exit.getFirst(), there, world)) continue;
                if (found != null) {
                    impetus.postDisplay((Component)Component.translatable((String)"hexcasting.tooltip.circle.many_exits", (Object[])new Object[]{Component.literal((String)this.currentPos.toShortString()).withStyle(ChatFormatting.RED)}), new ItemStack((ItemLike)Items.COMPASS));
                    ICircleComponent.sfx(this.currentPos, executorBlockState, (Level)world, Objects.requireNonNull(env.getImpetus()), false);
                    halt = true;
                    break;
                }
                found = exit;
            }
            if (found == null) {
                ICircleComponent.sfx(this.currentPos, executorBlockState, (Level)world, Objects.requireNonNull(env.getImpetus()), false);
                impetus.postNoExits(this.currentPos);
                halt = true;
            } else {
                ICircleComponent.sfx(this.currentPos, executorBlockState, (Level)world, Objects.requireNonNull(env.getImpetus()), true);
                this.currentPos = (BlockPos)found.getFirst();
                this.enteredFrom = (Direction)found.getSecond();
                this.currentImage = cont.update.withOverriddenUsedOps(0L);
            }
        }
        return !halt;
    }

    protected int getTickSpeed() {
        return Math.max(2, 10 - (this.reachedPositions.size() - 1) / 3);
    }

    public void endExecution(BlockEntityAbstractImpetus impetus) {
        ServerLevel world = (ServerLevel)impetus.getLevel();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.reachedPositions) {
            BlockState there = world.getBlockState(pos);
            Block block = there.getBlock();
            if (!(block instanceof ICircleComponent)) continue;
            ICircleComponent cc = (ICircleComponent)block;
            cc.endEnergized(pos, there, (Level)world);
        }
    }
}

