/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.advancements;

import at.petrak.hexcasting.api.advancements.MinMaxLongs;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class SpendMediaTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("hexcasting", "spend_media");
    private static final String TAG_MEDIA_SPENT = "media_spent";
    private static final String TAG_MEDIA_WASTED = "media_wasted";

    public ResourceLocation getId() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext context) {
        return new Instance(predicate, MinMaxLongs.fromJson(json.get(TAG_MEDIA_SPENT)), MinMaxLongs.fromJson(json.get(TAG_MEDIA_WASTED)));
    }

    public void trigger(ServerPlayer player, long mediaSpent, long mediaWasted) {
        super.trigger(player, inst -> inst.test(mediaSpent, mediaWasted));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxLongs mediaSpent;
        protected final MinMaxLongs mediaWasted;

        public Instance(ContextAwarePredicate predicate, MinMaxLongs mediaSpent, MinMaxLongs mediaWasted) {
            super(ID, predicate);
            this.mediaSpent = mediaSpent;
            this.mediaWasted = mediaWasted;
        }

        public ResourceLocation getCriterion() {
            return ID;
        }

        public JsonObject serializeToJson(SerializationContext ctx) {
            JsonObject json = super.serializeToJson(ctx);
            if (!this.mediaSpent.isAny()) {
                json.add(SpendMediaTrigger.TAG_MEDIA_SPENT, this.mediaSpent.serializeToJson());
            }
            if (!this.mediaWasted.isAny()) {
                json.add(SpendMediaTrigger.TAG_MEDIA_WASTED, this.mediaWasted.serializeToJson());
            }
            return json;
        }

        private boolean test(long mediaSpentIn, long mediaWastedIn) {
            return this.mediaSpent.matches(mediaSpentIn) && this.mediaWasted.matches(mediaWastedIn);
        }
    }
}

