/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.addldata;

import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.common.entities.EntityWallScroll;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class ItemDelegatingEntityIotaHolder
implements ADIotaHolder {
    private final Supplier<ItemStack> stackSupplier;
    private final Consumer<ItemStack> save;

    public ItemDelegatingEntityIotaHolder(Supplier<ItemStack> stackSupplier, Consumer<ItemStack> save) {
        this.stackSupplier = stackSupplier;
        this.save = save;
    }

    @Override
    @Nullable
    public CompoundTag readIotaTag() {
        ADIotaHolder delegate = IXplatAbstractions.INSTANCE.findDataHolder(this.stackSupplier.get());
        return delegate == null ? null : delegate.readIotaTag();
    }

    @Override
    public boolean writeable() {
        ADIotaHolder delegate = IXplatAbstractions.INSTANCE.findDataHolder(this.stackSupplier.get());
        return delegate != null && delegate.writeable();
    }

    @Override
    public boolean writeIota(@Nullable Iota datum, boolean simulate) {
        boolean success2;
        ItemStack stacc = this.stackSupplier.get();
        ADIotaHolder delegate = IXplatAbstractions.INSTANCE.findDataHolder(stacc);
        boolean bl = success2 = delegate != null && delegate.writeIota(datum, simulate);
        if (success2 && !simulate) {
            this.save.accept(stacc);
        }
        return success2;
    }

    @Override
    @Nullable
    public Iota readIota(ServerLevel world) {
        ADIotaHolder delegate = IXplatAbstractions.INSTANCE.findDataHolder(this.stackSupplier.get());
        return delegate == null ? null : delegate.readIota(world);
    }

    @Override
    @Nullable
    public Iota emptyIota() {
        ADIotaHolder delegate = IXplatAbstractions.INSTANCE.findDataHolder(this.stackSupplier.get());
        return delegate == null ? null : delegate.emptyIota();
    }

    public static class ToWallScroll
    extends ItemDelegatingEntityIotaHolder {
        public ToWallScroll(EntityWallScroll entity) {
            super(() -> entity.scroll.copy(), stack -> {});
        }

        @Override
        public boolean writeIota(@Nullable Iota datum, boolean simulate) {
            return false;
        }
    }

    public static class ToItemFrame
    extends ItemDelegatingEntityIotaHolder {
        public ToItemFrame(ItemFrame entity) {
            super(() -> ((ItemFrame)entity).getItem(), arg_0 -> ((ItemFrame)entity).setItem(arg_0));
        }
    }

    public static class ToItemEntity
    extends ItemDelegatingEntityIotaHolder {
        public ToItemEntity(ItemEntity entity) {
            super(() -> ((ItemEntity)entity).getItem(), stack -> {
                entity.setItem(ItemStack.EMPTY);
                entity.setItem(stack);
                entity.setUnlimitedLifetime();
            });
        }
    }
}

