/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.utils;

import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.interop.utils.PatternEntry;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public final class PatternDrawingUtil {
    public static void drawPattern(GuiGraphics graphics, int x, int y, List<PatternEntry> patterns, List<Vec2> dots, boolean strokeOrder, int outer, int innerLight, int innerDark, int dotColor) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 1.0f);
        Matrix4f mat = poseStack.last().pose();
        ShaderInstance prevShader = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.disableCull();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (PatternEntry pat : patterns) {
            RenderLib.drawLineSeq(mat, pat.zappyPoints(), 5.0f, 0.0f, outer, outer);
            RenderLib.drawLineSeq(mat, pat.zappyPoints(), 2.0f, 0.0f, strokeOrder ? innerDark : innerLight, innerLight);
            if (!strokeOrder) continue;
            RenderLib.drawSpot(mat, pat.zappyPoints().get(0), 2.5f, 1.0f, 0.1f, 0.15f, 0.6f);
        }
        float dotR = (float)FastColor.ARGB32.red((int)dotColor) / 255.0f;
        float dotG = (float)FastColor.ARGB32.green((int)dotColor) / 255.0f;
        float dotB = (float)FastColor.ARGB32.blue((int)dotColor) / 255.0f;
        float dotA = (float)FastColor.ARGB32.alpha((int)dotColor) / 255.0f;
        for (Vec2 dot : dots) {
            RenderLib.drawSpot(mat, dot, 1.5f, dotR, dotG, dotB, dotA);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(() -> prevShader);
        RenderSystem.enableCull();
        poseStack.popPose();
    }

    public static PatternRenderingData loadPatterns(List<Pair<HexPattern, HexCoord>> patterns, float readabilityOffset, float lastLineLenProp) {
        ArrayList<PatternEntry> patternEntries = new ArrayList<PatternEntry>(patterns.size());
        boolean fakeScale = true;
        ArrayList<Vec2> seenFakePoints = new ArrayList<Vec2>();
        HashSet<HexCoord> seenCoords = new HashSet<HexCoord>();
        for (Pair<HexPattern, HexCoord> pair : patterns) {
            HexPattern pattern = (HexPattern)pair.getFirst();
            HexCoord origin = (HexCoord)pair.getSecond();
            for (HexCoord pos : pattern.positions(origin)) {
                Vec2 px = HexUtils.coordToPx(pos, (float)fakeScale, Vec2.ZERO);
                seenFakePoints.add(px);
            }
            patternEntries.add(new PatternEntry(pattern, origin, new ArrayList<Vec2>()));
            seenCoords.addAll(pattern.positions(origin));
        }
        Vec2 fakeCom = HexUtils.findCenter(seenFakePoints);
        float maxDx = -1.0f;
        float maxDy = -1.0f;
        for (Vec2 dot : seenFakePoints) {
            float dy;
            float dx = Mth.abs((float)(dot.x - fakeCom.x));
            if (dx > maxDx) {
                maxDx = dx;
            }
            if (!((dy = Mth.abs((float)(dot.y - fakeCom.y))) > maxDy)) continue;
            maxDy = dy;
        }
        float hexSize = Math.min(12.0f, Math.min(48.0f / maxDx, 28.0f / maxDy));
        ArrayList<Vec2> seenRealPoints = new ArrayList<Vec2>();
        for (PatternEntry pat : patternEntries) {
            for (HexCoord pos : pat.pattern().positions(pat.origin())) {
                Vec2 px = HexUtils.coordToPx(pos, hexSize, Vec2.ZERO);
                seenRealPoints.add(px);
            }
        }
        Vec2 realCom = HexUtils.findCenter(seenRealPoints);
        for (int i = 0; i < patternEntries.size(); ++i) {
            PatternEntry pat = (PatternEntry)patternEntries.get(i);
            Vec2 localOrigin = HexUtils.coordToPx(pat.origin(), hexSize, realCom.negated());
            List<Vec2> points = pat.pattern().toLines(hexSize, localOrigin);
            pat.zappyPoints().addAll(RenderLib.makeZappy(points, RenderLib.findDupIndices(pat.pattern().positions()), 10, 0.8f, 0.0f, 0.0f, readabilityOffset, lastLineLenProp, i));
        }
        List<Vec2> pathfinderDots = seenCoords.stream().map(coord -> HexUtils.coordToPx(coord, hexSize, realCom.negated())).toList();
        return new PatternRenderingData(patternEntries, pathfinderDots, hexSize);
    }

    public record PatternRenderingData(List<PatternEntry> patterns, List<Vec2> pathfinderDots, float hexSize) {
    }
}

