/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.inline;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.api.InlineData;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class InlinePatternData
implements InlineData<InlinePatternData> {
    public static final ResourceLocation rendererId = HexAPI.modLoc("pattern");
    @NotNull
    public final HexPattern pattern;

    public InlinePatternData(@NotNull HexPattern pattern) {
        this.pattern = pattern;
    }

    public InlinePatternDataType getType() {
        return InlinePatternDataType.INSTANCE;
    }

    public ResourceLocation getRendererId() {
        return rendererId;
    }

    public Style getExtraStyle() {
        ItemStack scrollStack = new ItemStack((ItemLike)HexItems.SCROLL_MEDIUM);
        HexItems.SCROLL_MEDIUM.writeDatum(scrollStack, new PatternIota(this.pattern));
        scrollStack.setHoverName((Component)InlinePatternData.getPatternName(this.pattern).copy().withStyle(ChatFormatting.WHITE));
        HoverEvent he = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(scrollStack));
        ClickEvent ce = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.pattern.toString());
        return Style.EMPTY.withHoverEvent(he).withClickEvent(ce);
    }

    public static Component getPatternName(HexPattern pattern) {
        try {
            PatternShapeMatch shapeMatch = PatternRegistryManifest.matchPattern(pattern, null, false);
            if (shapeMatch instanceof PatternShapeMatch.Normal) {
                PatternShapeMatch.Normal normMatch = (PatternShapeMatch.Normal)shapeMatch;
                return HexAPI.instance().getActionI18n(normMatch.key, false);
            }
            if (shapeMatch instanceof PatternShapeMatch.Special) {
                PatternShapeMatch.Special specialMatch = (PatternShapeMatch.Special)shapeMatch;
                return HexAPI.instance().getSpecialHandlerI18n(specialMatch.key);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return PatternIota.displayNonInline(pattern);
    }

    public Component asText(boolean withExtra) {
        return Component.literal((String)this.pattern.toString()).withStyle(this.asStyle(withExtra));
    }

    public static class InlinePatternDataType
    implements InlineData.InlineDataType<InlinePatternData> {
        private static final ResourceLocation ID = new ResourceLocation("hexcasting", "pattern");
        public static final InlinePatternDataType INSTANCE = new InlinePatternDataType();

        public ResourceLocation getId() {
            return ID;
        }

        public Codec<InlinePatternData> getCodec() {
            return HexPattern.CODEC.xmap(InlinePatternData::new, data -> data.pattern);
        }
    }
}

