/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen.recipe.builders;

import at.petrak.hexcasting.datagen.recipe.builders.ProcessingOutput;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record ItemProcessingOutput(ItemStack stack, float chance) implements ProcessingOutput
{
    @Override
    public JsonObject serialize() {
        JsonObject json = new JsonObject();
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)this.stack.getItem());
        json.addProperty("item", resourceLocation.toString());
        int count = this.stack.getCount();
        if (count != 1) {
            json.addProperty("count", (Number)count);
        }
        if (this.stack.hasTag()) {
            json.add("nbt", JsonParser.parseString((String)this.stack.getTag().toString()));
        }
        if (this.chance != 1.0f) {
            json.addProperty("chance", (Number)Float.valueOf(this.chance));
        }
        return json;
    }
}

