/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.datagen;

import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.loot.HexLootHandler;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.paucal.api.datagen.PaucalLootTableSubProvider;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class HexLootTables
extends PaucalLootTableSubProvider {
    public HexLootTables() {
        super("hexcasting");
    }

    protected void makeLootTables(Map<Block, LootTable.Builder> blockTables, Map<ResourceLocation, LootTable.Builder> lootTables) {
        this.dropSelf(blockTables, new Block[]{HexBlocks.IMPETUS_EMPTY, HexBlocks.IMPETUS_RIGHTCLICK, HexBlocks.IMPETUS_LOOK, HexBlocks.IMPETUS_REDSTONE, HexBlocks.EMPTY_DIRECTRIX, HexBlocks.DIRECTRIX_REDSTONE, HexBlocks.DIRECTRIX_BOOLEAN, HexBlocks.AKASHIC_RECORD, HexBlocks.AKASHIC_BOOKSHELF, HexBlocks.AKASHIC_LIGATURE, HexBlocks.SLATE_BLOCK, HexBlocks.SLATE_TILES, HexBlocks.SLATE_BRICKS, HexBlocks.SLATE_BRICKS_SMALL, HexBlocks.SLATE_PILLAR, HexBlocks.AMETHYST_DUST_BLOCK, HexBlocks.AMETHYST_TILES, HexBlocks.AMETHYST_BRICKS, HexBlocks.AMETHYST_BRICKS_SMALL, HexBlocks.AMETHYST_PILLAR, HexBlocks.SLATE_AMETHYST_TILES, HexBlocks.SLATE_AMETHYST_BRICKS, HexBlocks.SLATE_AMETHYST_BRICKS_SMALL, HexBlocks.SLATE_AMETHYST_PILLAR, HexBlocks.QUENCHED_ALLAY_TILES, HexBlocks.QUENCHED_ALLAY_BRICKS, HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL, HexBlocks.SCROLL_PAPER, HexBlocks.ANCIENT_SCROLL_PAPER, HexBlocks.SCROLL_PAPER_LANTERN, HexBlocks.ANCIENT_SCROLL_PAPER_LANTERN, HexBlocks.SCONCE, HexBlocks.EDIFIED_LOG, HexBlocks.EDIFIED_LOG_AMETHYST, HexBlocks.EDIFIED_LOG_AVENTURINE, HexBlocks.EDIFIED_LOG_CITRINE, HexBlocks.EDIFIED_LOG_PURPLE, HexBlocks.STRIPPED_EDIFIED_LOG, HexBlocks.EDIFIED_WOOD, HexBlocks.STRIPPED_EDIFIED_WOOD, HexBlocks.EDIFIED_PLANKS, HexBlocks.EDIFIED_TILE, HexBlocks.EDIFIED_PANEL, HexBlocks.EDIFIED_TRAPDOOR, HexBlocks.EDIFIED_STAIRS, HexBlocks.EDIFIED_FENCE, HexBlocks.EDIFIED_FENCE_GATE, HexBlocks.EDIFIED_PRESSURE_PLATE, HexBlocks.EDIFIED_BUTTON});
        this.makeSlabTable(blockTables, (Block)HexBlocks.EDIFIED_SLAB);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AMETHYST_EDIFIED_LEAVES);
        this.makeLeafTable(blockTables, (Block)HexBlocks.AVENTURINE_EDIFIED_LEAVES);
        this.makeLeafTable(blockTables, (Block)HexBlocks.CITRINE_EDIFIED_LEAVES);
        LootPool.Builder slatePool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)HexBlocks.SLATE).apply((LootItemFunction.Builder)CopyNbtFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("pattern", "BlockEntityTag.pattern")));
        blockTables.put(HexBlocks.SLATE, LootTable.lootTable().withPool(slatePool));
        LootPool.Builder doorPool = this.dropThisPool((ItemLike)HexBlocks.EDIFIED_DOOR, 1).when((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder((Block)HexBlocks.EDIFIED_DOOR).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)));
        blockTables.put((Block)HexBlocks.EDIFIED_DOOR, LootTable.lootTable().withPool(doorPool));
        LootItemCondition.Builder silkTouchCond = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().hasEnchantment(new EnchantmentPredicate(Enchantments.SILK_TOUCH, MinMaxBounds.Ints.ANY)));
        LootItemCondition.Builder noSilkTouchCond = silkTouchCond.invert();
        LootItemCondition.Builder goodAtAmethystingCond = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(ItemTags.CLUSTER_MAX_HARVESTABLES));
        LootPool.Builder dustPoolWhenGood = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)HexItems.AMETHYST_DUST)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE)).when(noSilkTouchCond).when(goodAtAmethystingCond);
        LootPool.Builder dustPoolWhenBad = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)HexItems.AMETHYST_DUST)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).when(noSilkTouchCond).when(goodAtAmethystingCond.invert());
        LootPool.Builder isThatAnMFingBrandonSandersonReference = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)HexItems.CHARGED_AMETHYST)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(noSilkTouchCond).when(goodAtAmethystingCond).when(BonusLevelTableCondition.bonusLevelFlatChance((Enchantment)Enchantments.BLOCK_FORTUNE, (float[])new float[]{0.25f, 0.35f, 0.5f, 0.75f, 1.0f}));
        LootPool.Builder isThatAnMFingBadBrandonSandersonReference = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)HexItems.CHARGED_AMETHYST)).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(noSilkTouchCond).when(goodAtAmethystingCond.invert()).when(LootItemRandomChanceCondition.randomChance((float)0.125f));
        lootTables.put(HexLootHandler.TABLE_INJECT_AMETHYST_CLUSTER, LootTable.lootTable().withPool(dustPoolWhenGood).withPool(dustPoolWhenBad).withPool(isThatAnMFingBrandonSandersonReference).withPool(isThatAnMFingBadBrandonSandersonReference));
        LootPool.Builder quenchedPool = LootPool.lootPool().add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)HexBlocks.QUENCHED_ALLAY).when(silkTouchCond), LootItem.lootTableItem((ItemLike)HexItems.QUENCHED_SHARD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when(BonusLevelTableCondition.bonusLevelFlatChance((Enchantment)Enchantments.BLOCK_FORTUNE, (float[])new float[]{0.25f, 0.5f, 0.75f, 1.0f})))}));
        blockTables.put(HexBlocks.QUENCHED_ALLAY, LootTable.lootTable().withPool(quenchedPool));
    }

    private void makeLeafTable(Map<Block, LootTable.Builder> lootTables, Block block) {
        LootPool.Builder leafPool = this.dropThisPool((ItemLike)block, 1).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{IXplatAbstractions.INSTANCE.isShearsCondition(), MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().hasEnchantment(new EnchantmentPredicate(Enchantments.SILK_TOUCH, MinMaxBounds.Ints.atLeast((int)1))))}));
        lootTables.put(block, LootTable.lootTable().withPool(leafPool));
    }

    private void makeSlabTable(Map<Block, LootTable.Builder> lootTables, Block block) {
        LootPool.Builder leafPool = this.dropThisPool((ItemLike)block, 1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)new LootItemBlockStatePropertyCondition.Builder(block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay());
        lootTables.put(block, LootTable.lootTable().withPool(leafPool));
    }
}

