/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlocks;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StateIngredientTag
extends StateIngredientBlocks {
    private final TagKey<Block> tag;

    public StateIngredientTag(ResourceLocation tag) {
        super((Collection<Block>)ImmutableSet.of());
        this.tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tag);
    }

    public Stream<Block> resolve() {
        return StreamSupport.stream(BuiltInRegistries.BLOCK.getTagOrEmpty(this.tag).spliterator(), false).map(Holder::value);
    }

    @Override
    public boolean test(BlockState state) {
        return state.is(this.tag);
    }

    @Override
    public BlockState pick(Random random) {
        List<Block> values = this.resolve().toList();
        if (values.isEmpty()) {
            return null;
        }
        return values.get(random.nextInt(values.size())).defaultBlockState();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "tag");
        object.addProperty("tag", this.tag.location().toString());
        return object;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.resolve().filter(b -> b.asItem() != Items.AIR).map(ItemStack::new).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    protected List<Block> getBlocks() {
        return this.resolve().toList();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return this.resolve().map(Block::defaultBlockState).collect(Collectors.toList());
    }

    public ResourceLocation getTagId() {
        return this.tag.location();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.tag.equals(((StateIngredientTag)o).tag);
    }

    @Override
    public int hashCode() {
        return this.tag.hashCode();
    }

    @Override
    public String toString() {
        return "StateIngredientTag{" + this.tag + "}";
    }
}

