/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe;

import at.petrak.hexcasting.common.recipe.HexRecipeStuffRegistry;
import at.petrak.hexcasting.common.recipe.RecipeSerializerBase;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientHelper;
import at.petrak.hexcasting.common.recipe.ingredient.brainsweep.BrainsweepeeIngredient;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public record BrainsweepRecipe(ResourceLocation id, StateIngredient blockIn, BrainsweepeeIngredient entityIn, long mediaCost, BlockState result) implements Recipe<Container>
{
    public boolean matches(BlockState blockIn, Entity victim, ServerLevel level) {
        return this.blockIn.test(blockIn) && this.entityIn.test(victim, level);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public RecipeType<?> getType() {
        return HexRecipeStuffRegistry.BRAINSWEEP_TYPE;
    }

    public RecipeSerializer<?> getSerializer() {
        return HexRecipeStuffRegistry.BRAINSWEEP;
    }

    public boolean matches(Container pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(Container pContainer, RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return ItemStack.EMPTY.copy();
    }

    public static BlockState copyProperties(BlockState original, BlockState copyTo) {
        for (Property prop : original.getProperties()) {
            if (!copyTo.hasProperty(prop)) continue;
            copyTo = (BlockState)copyTo.setValue(prop, original.getValue(prop));
        }
        return copyTo;
    }

    public static class Serializer
    extends RecipeSerializerBase<BrainsweepRecipe> {
        @NotNull
        public BrainsweepRecipe fromJson(ResourceLocation recipeID, JsonObject json) {
            StateIngredient blockIn = StateIngredientHelper.deserialize(GsonHelper.getAsJsonObject((JsonObject)json, (String)"blockIn"));
            BrainsweepeeIngredient villagerIn = BrainsweepeeIngredient.deserialize(GsonHelper.getAsJsonObject((JsonObject)json, (String)"entityIn"));
            int cost = GsonHelper.getAsInt((JsonObject)json, (String)"cost");
            BlockState result = StateIngredientHelper.readBlockState(GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            return new BrainsweepRecipe(recipeID, blockIn, villagerIn, cost, result);
        }

        public void toNetwork(FriendlyByteBuf buf, BrainsweepRecipe recipe) {
            recipe.blockIn.write(buf);
            recipe.entityIn.wrapWrite(buf);
            buf.writeVarLong(recipe.mediaCost);
            buf.writeVarInt(Block.getId((BlockState)recipe.result));
        }

        @NotNull
        public BrainsweepRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buf) {
            StateIngredient blockIn = StateIngredientHelper.read(buf);
            BrainsweepeeIngredient brainsweepeeIn = BrainsweepeeIngredient.read(buf);
            long cost = buf.readVarLong();
            BlockState result = Block.stateById((int)buf.readVarInt());
            return new BrainsweepRecipe(recipeID, blockIn, brainsweepeeIn, cost, result);
        }
    }
}

