/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class HexSounds {
    private static final Map<ResourceLocation, SoundEvent> SOUNDS = new LinkedHashMap<ResourceLocation, SoundEvent>();
    public static final SoundEvent START_PATTERN = HexSounds.sound("casting.pattern.start");
    public static final SoundEvent ADD_TO_PATTERN = HexSounds.sound("casting.pattern.add_segment");
    public static final SoundEvent CASTING_AMBIANCE = HexSounds.sound("casting.ambiance");
    public static final SoundEvent CAST_NORMAL = HexSounds.sound("casting.cast.normal");
    public static final SoundEvent CAST_SPELL = HexSounds.sound("casting.cast.spell");
    public static final SoundEvent CAST_HERMES = HexSounds.sound("casting.cast.hermes");
    public static final SoundEvent CAST_THOTH = HexSounds.sound("casting.cast.thoth");
    public static final SoundEvent CAST_FAILURE = HexSounds.sound("casting.cast.fail");
    public static final SoundEvent ABACUS = HexSounds.sound("abacus");
    public static final SoundEvent ABACUS_SHAKE = HexSounds.sound("abacus.shake");
    public static final SoundEvent STAFF_RESET = HexSounds.sound("staff.reset");
    public static final SoundEvent SPELL_CIRCLE_FIND_BLOCK = HexSounds.sound("spellcircle.find_block");
    public static final SoundEvent SPELL_CIRCLE_FAIL = HexSounds.sound("spellcircle.fail");
    public static final SoundEvent SCROLL_DUST = HexSounds.sound("scroll.dust");
    public static final SoundEvent SCROLL_SCRIBBLE = HexSounds.sound("scroll.scribble");
    public static final SoundEvent IMPETUS_LOOK_TICK = HexSounds.sound("impetus.fletcher.tick");
    public static final SoundEvent IMPETUS_REDSTONE_DING = HexSounds.sound("impetus.redstone.register");
    public static final SoundEvent READ_LORE_FRAGMENT = HexSounds.sound("lore_fragment.read");
    public static final SoundEvent FLIGHT_AMBIENCE = HexSounds.sound("flight.ambience");
    public static final SoundEvent FLIGHT_FINISH = HexSounds.sound("flight.finish");

    public static void registerSounds(BiConsumer<SoundEvent, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, SoundEvent> e : SOUNDS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static SoundEvent sound(String name) {
        SoundEvent sound;
        ResourceLocation id = HexAPI.modLoc(name);
        SoundEvent old = SOUNDS.put(id, sound = SoundEvent.createVariableRangeEvent((ResourceLocation)id));
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return sound;
    }
}

