/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.utils.MathUtils;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class ItemMediaHolder
extends Item
implements MediaHolderItem {
    public static final String TAG_MEDIA = "hexcasting:media";
    public static final String TAG_MAX_MEDIA = "hexcasting:start_media";
    public static final TextColor HEX_COLOR = TextColor.fromRgb((int)11767539);
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("####");
    private static final DecimalFormat DUST_AMOUNT;

    public ItemMediaHolder(Item.Properties pProperties) {
        super(pProperties);
    }

    public static ItemStack withMedia(ItemStack stack, long media, long maxMedia) {
        Item item = stack.getItem();
        if (item instanceof ItemMediaHolder) {
            NBTHelper.putLong(stack, TAG_MEDIA, media);
            NBTHelper.putLong(stack, TAG_MAX_MEDIA, maxMedia);
        }
        return stack;
    }

    @Override
    public long getMedia(ItemStack stack) {
        if (NBTHelper.hasInt(stack, TAG_MEDIA)) {
            return NBTHelper.getInt(stack, TAG_MEDIA);
        }
        return NBTHelper.getLong(stack, TAG_MEDIA);
    }

    @Override
    public long getMaxMedia(ItemStack stack) {
        if (NBTHelper.hasInt(stack, TAG_MAX_MEDIA)) {
            return NBTHelper.getInt(stack, TAG_MAX_MEDIA);
        }
        return NBTHelper.getLong(stack, TAG_MAX_MEDIA);
    }

    @Override
    public void setMedia(ItemStack stack, long media) {
        NBTHelper.putLong(stack, TAG_MEDIA, MathUtils.clamp(media, 0L, this.getMaxMedia(stack)));
    }

    public boolean isBarVisible(ItemStack pStack) {
        return this.getMaxMedia(pStack) > 0L;
    }

    public int getBarColor(ItemStack pStack) {
        long media = this.getMedia(pStack);
        long maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarColor(media, maxMedia);
    }

    public int getBarWidth(ItemStack pStack) {
        long media = this.getMedia(pStack);
        long maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarWidth(media, maxMedia);
    }

    public boolean canBeDepleted() {
        return false;
    }

    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        long maxMedia = this.getMaxMedia(pStack);
        if (maxMedia > 0L) {
            long media = this.getMedia(pStack);
            float fullness = this.getMediaFullness(pStack);
            TextColor color = TextColor.fromRgb((int)MediaHelper.mediaBarColor(media, maxMedia));
            MutableComponent mediamount = Component.literal((String)DUST_AMOUNT.format((float)media / 10000.0f));
            MutableComponent percentFull = Component.literal((String)(PERCENTAGE.format(100.0f * fullness) + "%"));
            MutableComponent maxCapacity = Component.translatable((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format((float)maxMedia / 10000.0f)});
            mediamount.withStyle(style -> style.withColor(HEX_COLOR));
            maxCapacity.withStyle(style -> style.withColor(HEX_COLOR));
            percentFull.withStyle(style -> style.withColor(color));
            pTooltipComponents.add((Component)Component.translatable((String)"hexcasting.tooltip.media_amount.advanced", (Object[])new Object[]{mediamount, maxCapacity, percentFull}));
        }
        super.appendHoverText(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        PERCENTAGE.setRoundingMode(RoundingMode.DOWN);
        DUST_AMOUNT = new DecimalFormat("###,###.##");
    }
}

