/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items;

import at.petrak.hexcasting.common.items.HexBaubleItem;
import at.petrak.hexcasting.common.lib.HexAttributes;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.core.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemLens
extends Item
implements HexBaubleItem {
    public static final AttributeModifier GRID_ZOOM = new AttributeModifier(UUID.fromString("59d739b8-d419-45f7-a4ea-0efee0e3adf5"), "Scrying Lens Zoom", 0.33, AttributeModifier.Operation.MULTIPLY_BASE);
    public static final AttributeModifier SCRY_SIGHT = new AttributeModifier(UUID.fromString("e2e6e5d4-f978-4c11-8fdc-82a5af83385c"), "Scrying Lens Sight", 1.0, AttributeModifier.Operation.ADDITION);

    public ItemLens(Item.Properties pProperties) {
        super(pProperties);
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            @NotNull
            protected ItemStack execute(@NotNull BlockSource world, @NotNull ItemStack stack) {
                this.setSuccess(ArmorItem.dispenseArmor((BlockSource)world, (ItemStack)stack));
                return stack;
            }
        });
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        HashMultimap out = HashMultimap.create((Multimap)super.getDefaultAttributeModifiers(slot));
        if (slot == EquipmentSlot.HEAD || slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            out.put((Object)HexAttributes.GRID_ZOOM, (Object)GRID_ZOOM);
            out.put((Object)HexAttributes.SCRY_SIGHT, (Object)SCRY_SIGHT);
        }
        return out;
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getHexBaubleAttrs(ItemStack stack) {
        HashMultimap out = HashMultimap.create();
        out.put((Object)HexAttributes.GRID_ZOOM, (Object)GRID_ZOOM);
        out.put((Object)HexAttributes.SCRY_SIGHT, (Object)SCRY_SIGHT);
        return out;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

