/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.command.PatternResLocArgument;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ListPerWorldPatternsCommand {
    public static void add(LiteralArgumentBuilder<CommandSourceStack> cmd) {
        cmd.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"perWorldPatterns").requires(dp -> dp.hasPermission(2))).then(Commands.literal((String)"list").executes(ctx -> ListPerWorldPatternsCommand.list((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"patternName", (ArgumentType)PatternResLocArgument.id()).executes(ctx -> ListPerWorldPatternsCommand.giveOne((CommandSourceStack)ctx.getSource(), ListPerWorldPatternsCommand.getDefaultTarget((CommandSourceStack)ctx.getSource()), ResourceLocationArgument.getId((CommandContext)ctx, (String)"patternName"), PatternResLocArgument.getPattern((CommandContext<CommandSourceStack>)ctx, "patternName")))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> ListPerWorldPatternsCommand.giveOne((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.getId((CommandContext)ctx, (String)"patternName"), PatternResLocArgument.getPattern((CommandContext<CommandSourceStack>)ctx, "patternName"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"giveAll").executes(ctx -> ListPerWorldPatternsCommand.giveAll((CommandSourceStack)ctx.getSource(), ListPerWorldPatternsCommand.getDefaultTarget((CommandSourceStack)ctx.getSource())))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> ListPerWorldPatternsCommand.giveAll((CommandSourceStack)ctx.getSource(), EntityArgument.getPlayers((CommandContext)ctx, (String)"targets"))))));
    }

    private static Collection<ServerPlayer> getDefaultTarget(CommandSourceStack source) {
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return List.of(player);
        }
        return List.of();
    }

    private static int list(CommandSourceStack source) {
        Set keys = IXplatAbstractions.INSTANCE.getActionRegistry().registryKeySet();
        List listing = keys.stream().sorted((a, b) -> ListPerWorldPatternsCommand.compareResLoc(a.location(), b.location())).toList();
        ServerLevel ow = source.getLevel().getServer().overworld();
        source.sendSuccess(() -> Component.translatable((String)"command.hexcasting.pats.listing"), false);
        for (ResourceKey key : listing) {
            HexPattern pat = PatternRegistryManifest.getCanonicalStrokesPerWorld((ResourceKey<ActionRegistryEntry>)key, ow);
            source.sendSuccess(() -> Component.literal((String)key.location().toString()).append(": ").append(new PatternIota(pat).display()), false);
        }
        return keys.size();
    }

    private static int giveAll(CommandSourceStack source, Collection<ServerPlayer> targets) {
        if (!targets.isEmpty()) {
            ServerLevel ow = source.getLevel().getServer().overworld();
            ScrungledPatternsSave save = ScrungledPatternsSave.open(ow);
            Registry<ActionRegistryEntry> regi = IXplatAbstractions.INSTANCE.getActionRegistry();
            int count = 0;
            for (Map.Entry entry : regi.entrySet()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                if (!HexUtils.isOfTag(regi, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
                Pair<String, ScrungledPatternsSave.PerWorldEntry> found = save.lookupReverse((ResourceKey<ActionRegistryEntry>)key);
                String signature = (String)found.getFirst();
                HexDir startDir = ((ScrungledPatternsSave.PerWorldEntry)found.getSecond()).canonicalStartDir();
                HexPattern pat = HexPattern.fromAngles(signature, startDir);
                CompoundTag tag = new CompoundTag();
                tag.putString("op_id", key.location().toString());
                tag.put("pattern", (Tag)pat.serializeToNBT());
                ItemStack stack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
                stack.setTag(tag);
                for (ServerPlayer player : targets) {
                    ItemEntity stackEntity = player.drop(stack, false);
                    if (stackEntity != null) {
                        stackEntity.setNoPickUpDelay();
                        stackEntity.setThrower(player.getUUID());
                    }
                    ++count;
                }
            }
            int finalCount = count;
            source.sendSuccess(() -> Component.translatable((String)"command.hexcasting.pats.all", (Object[])new Object[]{finalCount, targets.size() == 1 ? ((ServerPlayer)targets.iterator().next()).getDisplayName() : Integer.valueOf(targets.size())}), true);
            return count;
        }
        return 0;
    }

    private static int giveOne(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation patternName, HexPattern pat) {
        if (!targets.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            tag.putString("op_id", patternName.toString());
            tag.put("pattern", (Tag)pat.serializeToNBT());
            ItemStack stack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
            stack.setTag(tag);
            source.sendSuccess(() -> Component.translatable((String)"command.hexcasting.pats.specific.success", (Object[])new Object[]{stack.getDisplayName(), patternName, targets.size() == 1 ? ((ServerPlayer)targets.iterator().next()).getDisplayName() : Integer.valueOf(targets.size())}), true);
            for (ServerPlayer player : targets) {
                ItemEntity stackEntity = player.drop(stack, false);
                if (stackEntity == null) continue;
                stackEntity.setNoPickUpDelay();
                stackEntity.setThrower(player.getUUID());
            }
            return targets.size();
        }
        return 0;
    }

    private static int compareResLoc(ResourceLocation a, ResourceLocation b) {
        int ns = a.getNamespace().compareTo(b.getNamespace());
        if (ns != 0) {
            return ns;
        }
        return a.getPath().compareTo(b.getPath());
    }
}

