/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.arithmetic.operator;

import at.petrak.hexcasting.api.casting.arithmetic.operator.OperatorBasic;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaMultiPredicate;
import at.petrak.hexcasting.api.casting.arithmetic.predicates.IotaPredicate;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.iota.DoubleIota;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapDivideByZero;
import at.petrak.hexcasting.common.casting.arithmetic.operator.OperatorUtilsKt;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lat/petrak/hexcasting/common/casting/arithmetic/operator/OperatorLog;", "Lat/petrak/hexcasting/api/casting/arithmetic/operator/OperatorBasic;", "()V", "apply", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "iotas", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "hexcasting-common-1.20.1"})
public final class OperatorLog
extends OperatorBasic {
    @NotNull
    public static final OperatorLog INSTANCE = new OperatorLog();

    private OperatorLog() {
        IotaMultiPredicate iotaMultiPredicate = IotaMultiPredicate.all(IotaPredicate.ofType(HexIotaTypes.DOUBLE));
        Intrinsics.checkNotNullExpressionValue((Object)iotaMultiPredicate, (String)"all(IotaPredicate.ofType(DOUBLE))");
        super(2, iotaMultiPredicate);
    }

    @Override
    @NotNull
    public Iterable<Iota> apply(@NotNull Iterable<? extends Iota> iotas, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(iotas, (String)"iotas");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Iterator it = CollectionsKt.withIndex(iotas.iterator());
        double value = OperatorUtilsKt.nextDouble(it, this.arity);
        double base = OperatorUtilsKt.nextDouble(it, this.arity);
        if (value <= 0.0 || base <= 0.0 || base == 1.0) {
            throw MishapDivideByZero.Companion.of((Iota)CollectionsKt.first(iotas), (Iota)CollectionsKt.last(iotas), "logarithm");
        }
        double $this$asActionResult$iv = MathKt.log((double)value, (double)base);
        boolean $i$f$getAsActionResult = false;
        return CollectionsKt.listOf((Object)new DoubleIota($this$asActionResult$iv));
    }
}

