/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadBlock;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpConjureBlock;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "light", "", "(Z)V", "argc", "", "getArgc", "()I", "getLight", "()Z", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpConjureBlock
implements SpellAction {
    private final boolean light;
    private final int argc;

    public OpConjureBlock(boolean light) {
        this.light = light;
        this.argc = 1;
    }

    public final boolean getLight() {
        return this.light;
    }

    @Override
    public int getArgc() {
        return this.argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 vecPos = OperatorUtils.getVec3(args, 0, this.getArgc());
        BlockPos pos = BlockPos.containing((Position)((Position)vecPos));
        env.assertPosInRangeForEditing(pos);
        DirectionalPlaceContext placeContext = new DirectionalPlaceContext((Level)env.getWorld(), pos, Direction.DOWN, ItemStack.EMPTY, Direction.UP);
        BlockState worldState = env.getWorld().getBlockState(pos);
        if (!worldState.canBeReplaced((BlockPlaceContext)placeContext)) {
            Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
            throw MishapBadBlock.Companion.of(pos, "replaceable");
        }
        Intrinsics.checkNotNullExpressionValue((Object)pos, (String)"pos");
        RenderedSpell renderedSpell = new Spell(pos, this.light);
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)((Vec3i)pos));
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(pos)");
        return new SpellAction.Result(renderedSpell, 10000L, CollectionsKt.listOf((Object)ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpConjureBlock$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "pos", "Lnet/minecraft/core/BlockPos;", "light", "", "(Lnet/minecraft/core/BlockPos;Z)V", "getLight", "()Z", "getPos", "()Lnet/minecraft/core/BlockPos;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final BlockPos pos;
        private final boolean light;

        public Spell(@NotNull BlockPos pos, boolean light) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
            this.light = light;
        }

        @NotNull
        public final BlockPos getPos() {
            return this.pos;
        }

        public final boolean getLight() {
            return this.light;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!env.canEditBlockAt(this.pos)) {
                return;
            }
            DirectionalPlaceContext placeContext = new DirectionalPlaceContext((Level)env.getWorld(), this.pos, Direction.DOWN, ItemStack.EMPTY, Direction.UP);
            BlockState worldState = env.getWorld().getBlockState(this.pos);
            if (worldState.canBeReplaced((BlockPlaceContext)placeContext)) {
                Block block = this.light ? HexBlocks.CONJURED_LIGHT : HexBlocks.CONJURED_BLOCK;
                LivingEntity livingEntity = env.getCastingEntity();
                if (!IXplatAbstractions.INSTANCE.isPlacingAllowed(env.getWorld(), this.pos, new ItemStack((ItemLike)block), (Player)(livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null))) {
                    return;
                }
                BlockState state = block.getStateForPlacement((BlockPlaceContext)placeContext);
                if (state != null) {
                    env.getWorld().setBlock(this.pos, state, 3);
                    FrozenPigment pigment = env.getPigment();
                    if (env.getWorld().getBlockState(this.pos).getBlock() instanceof BlockConjured) {
                        BlockConjured.setColor((LevelAccessor)env.getWorld(), this.pos, pigment);
                    }
                }
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final BlockPos component1() {
            return this.pos;
        }

        public final boolean component2() {
            return this.light;
        }

        @NotNull
        public final Spell copy(@NotNull BlockPos pos, boolean light) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new Spell(pos, light);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, BlockPos blockPos, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = spell.pos;
            }
            if ((n & 2) != 0) {
                bl = spell.light;
            }
            return spell.copy(blockPos, bl);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ", light=" + this.light + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            int n = this.light ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            return this.light == spell.light;
        }
    }
}

