/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.casting.mishaps.MishapImmuneEntity;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.common.casting.actions.spells.great.OpTeleport;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpBlink;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "()V", "argc", "", "getArgc", "()I", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-common-1.20.1"})
public final class OpBlink
implements SpellAction {
    @NotNull
    public static final OpBlink INSTANCE = new OpBlink();
    private static final int argc = 2;

    private OpBlink() {
    }

    @Override
    public int getArgc() {
        return argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Entity target = OperatorUtils.getEntity(args, 0, this.getArgc());
        double delta = OperatorUtils.getDouble(args, 1, this.getArgc());
        env.assertEntityInRange(target);
        if (!target.canChangeDimensions() || target.getType().is(HexTags.Entities.CANNOT_TELEPORT)) {
            throw new MishapImmuneEntity(target);
        }
        Vec3 dvec = target.getLookAngle().scale(delta);
        Vec3 endPos = target.position().add(dvec);
        if (!HexConfig.server().canTeleportInThisDimension((ResourceKey<Level>)env.getWorld().dimension())) {
            Intrinsics.checkNotNullExpressionValue((Object)endPos, (String)"endPos");
            throw new MishapBadLocation(endPos, "bad_dimension");
        }
        env.assertVecInRange(target.position());
        env.assertVecInRange(endPos);
        if (!env.isVecInWorld(endPos.subtract(0.0, 1.0, 0.0))) {
            Intrinsics.checkNotNullExpressionValue((Object)endPos, (String)"endPos");
            throw new MishapBadLocation(endPos, "too_close_to_out");
        }
        Vec3 targetMiddlePos = target.position().add(0.0, (double)target.getEyeHeight() / 2.0, 0.0);
        RenderedSpell renderedSpell = new Spell(target, delta);
        long l = MathKt.roundToLong((double)((double)50000L * Math.abs(delta) * 0.5));
        Object[] objectArray = new ParticleSpray[2];
        Intrinsics.checkNotNullExpressionValue((Object)targetMiddlePos, (String)"targetMiddlePos");
        objectArray[0] = ParticleSpray.Companion.cloud(targetMiddlePos, 2.0, 50);
        Vec3 vec3 = targetMiddlePos.add(dvec);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"targetMiddlePos.add(dvec)");
        objectArray[1] = ParticleSpray.Companion.burst(vec3, 2.0, 100);
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object[])objectArray), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpBlink$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "target", "Lnet/minecraft/world/entity/Entity;", "delta", "", "(Lnet/minecraft/world/entity/Entity;D)V", "getDelta", "()D", "getTarget", "()Lnet/minecraft/world/entity/Entity;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexcasting-common-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Entity target;
        private final double delta;

        public Spell(@NotNull Entity target, double delta) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.target = target;
            this.delta = delta;
        }

        @NotNull
        public final Entity getTarget() {
            return this.target;
        }

        public final double getDelta() {
            return this.delta;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!HexConfig.server().canTeleportInThisDimension((ResourceKey<Level>)env.getWorld().dimension())) {
                return;
            }
            Vec3 delta = this.target.getLookAngle().scale(this.delta);
            Intrinsics.checkNotNullExpressionValue((Object)delta, (String)"delta");
            ServerLevel serverLevel = env.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"env.world");
            OpTeleport.INSTANCE.teleportRespectSticky(this.target, delta, serverLevel);
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Entity component1() {
            return this.target;
        }

        public final double component2() {
            return this.delta;
        }

        @NotNull
        public final Spell copy(@NotNull Entity target, double delta) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(target, delta);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Entity entity, double d, int n, Object object) {
            if ((n & 1) != 0) {
                entity = spell.target;
            }
            if ((n & 2) != 0) {
                d = spell.delta;
            }
            return spell.copy(entity, d);
        }

        @NotNull
        public String toString() {
            return "Spell(target=" + this.target + ", delta=" + this.delta + ")";
        }

        public int hashCode() {
            int result = this.target.hashCode();
            result = result * 31 + Double.hashCode(this.delta);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            return Double.compare(this.delta, spell.delta) == 0;
        }
    }
}

