/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.entity;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.blocks.BlockConjuredLight;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockEntityConjured
extends HexBlockEntity {
    private static final Random RANDOM = new Random();
    private FrozenPigment colorizer = FrozenPigment.DEFAULT.get();
    public static final String TAG_COLORIZER = "tag_colorizer";

    public BlockEntityConjured(BlockPos pos, BlockState state) {
        super(HexBlockEntities.CONJURED_TILE, pos, state);
    }

    public void walkParticle(Entity pEntity) {
        BlockConjured conjured;
        Block block = this.getBlockState().getBlock();
        if (block instanceof BlockConjured && !((conjured = (BlockConjured)block) instanceof BlockConjuredLight)) {
            ColorProvider colProvider = this.colorizer.getColorProvider();
            for (int i = 0; i < 3; ++i) {
                int color = colProvider.getColor(pEntity.tickCount, pEntity.position().add(new Vec3((double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat()).scale((double)(RANDOM.nextFloat() * 3.0f))));
                assert (this.level != null);
                this.level.addParticle((ParticleOptions)new ConjureParticleOptions(color), pEntity.getX() + (double)RANDOM.nextFloat() * 0.6 - 0.3, (double)this.getBlockPos().getY() + (double)RANDOM.nextFloat() * 0.05 + 0.95, pEntity.getZ() + (double)RANDOM.nextFloat() * 0.6 - 0.3, (double)RANDOM.nextFloat(-0.02f, 0.02f), (double)RANDOM.nextFloat(0.02f), (double)RANDOM.nextFloat(-0.02f, 0.02f));
            }
        }
    }

    public void particleEffect() {
        if (this.getBlockState().getBlock() instanceof BlockConjured) {
            int color = this.colorizer.getColorProvider().getColor(RANDOM.nextFloat() * 16384.0f, new Vec3((double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat()).scale((double)(RANDOM.nextFloat() * 3.0f)));
            assert (this.level != null);
            if (this.getBlockState().getBlock() instanceof BlockConjuredLight) {
                if ((double)RANDOM.nextFloat() < 0.5) {
                    this.level.addParticle((ParticleOptions)new ConjureParticleOptions(color), (double)this.getBlockPos().getX() + 0.45 + (double)RANDOM.nextFloat() * 0.1, (double)this.getBlockPos().getY() + 0.45 + (double)RANDOM.nextFloat() * 0.1, (double)this.getBlockPos().getZ() + 0.45 + (double)RANDOM.nextFloat() * 0.1, (double)RANDOM.nextFloat(-0.005f, 0.005f), (double)RANDOM.nextFloat(-0.002f, 0.02f), (double)RANDOM.nextFloat(-0.005f, 0.005f));
                }
            } else if ((double)RANDOM.nextFloat() < 0.2) {
                this.level.addParticle((ParticleOptions)new ConjureParticleOptions(color), (double)this.getBlockPos().getX() + (double)RANDOM.nextFloat(), (double)this.getBlockPos().getY() + (double)RANDOM.nextFloat(), (double)this.getBlockPos().getZ() + (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(-0.02f, 0.02f), (double)RANDOM.nextFloat(-0.02f, 0.02f), (double)RANDOM.nextFloat(-0.02f, 0.02f));
            }
        }
    }

    public void landParticle(Entity entity, int number) {
        ColorProvider colProvider = this.colorizer.getColorProvider();
        for (int i = 0; i < number * 2; ++i) {
            int color = colProvider.getColor(entity.tickCount, entity.position().add(new Vec3((double)RANDOM.nextFloat(), (double)RANDOM.nextFloat(), (double)RANDOM.nextFloat()).scale((double)(RANDOM.nextFloat() * 3.0f))));
            assert (this.level != null);
            this.level.addParticle((ParticleOptions)new ConjureParticleOptions(color), entity.getX() + (double)RANDOM.nextFloat() * 0.8 - 0.2, (double)this.getBlockPos().getY() + (double)RANDOM.nextFloat() * 0.05 + 0.95, entity.getZ() + (double)RANDOM.nextFloat() * 0.8 - 0.2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        tag.put(TAG_COLORIZER, (Tag)this.colorizer.serializeToNBT());
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        this.colorizer = FrozenPigment.fromNBT(tag.getCompound(TAG_COLORIZER));
    }

    public FrozenPigment getColorizer() {
        return this.colorizer;
    }

    public void setColorizer(FrozenPigment colorizer) {
        this.colorizer = colorizer;
        this.sync();
    }
}

