/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles.impetuses;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockEntityRedstoneImpetus
extends BlockEntityAbstractImpetus {
    public static final String TAG_STORED_PLAYER = "stored_player";
    public static final String TAG_STORED_PLAYER_PROFILE = "stored_player_profile";
    private GameProfile storedPlayerProfile = null;
    private UUID storedPlayer = null;
    private GameProfile cachedDisplayProfile = null;
    private ItemStack cachedDisplayStack = null;

    public BlockEntityRedstoneImpetus(BlockPos pWorldPosition, BlockState pBlockState) {
        super(HexBlockEntities.IMPETUS_REDSTONE_TILE, pWorldPosition, pBlockState);
    }

    @Nullable
    protected GameProfile getPlayerName() {
        ServerPlayer player;
        if (this.level instanceof ServerLevel && (player = this.getStoredPlayer()) != null) {
            return player.getGameProfile();
        }
        return this.storedPlayerProfile;
    }

    public void setPlayer(GameProfile profile, UUID player) {
        this.storedPlayerProfile = profile;
        this.storedPlayer = player;
        this.setChanged();
    }

    public void clearPlayer() {
        this.storedPlayerProfile = null;
        this.storedPlayer = null;
    }

    public void updatePlayerProfile() {
        ServerPlayer player = this.getStoredPlayer();
        if (player != null) {
            GameProfile newProfile = player.getGameProfile();
            if (!newProfile.equals((Object)this.storedPlayerProfile)) {
                this.storedPlayerProfile = newProfile;
                this.setChanged();
            }
        } else {
            this.storedPlayerProfile = null;
        }
    }

    @Nullable
    public ServerPlayer getStoredPlayer() {
        if (this.storedPlayer == null) {
            return null;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            HexAPI.LOGGER.error("Called getStoredPlayer on the client");
            return null;
        }
        ServerLevel slevel = (ServerLevel)level;
        Entity e = slevel.getEntity(this.storedPlayer);
        if (e instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)e;
            return player;
        }
        HexAPI.LOGGER.error("Entity {} stored in a cleric impetus wasn't a player somehow", (Object)e);
        return null;
    }

    @Override
    public void applyScryingLensOverlay(List<Pair<ItemStack, Component>> lines, BlockState state, BlockPos pos, Player observer, Level world, Direction hitFace) {
        super.applyScryingLensOverlay(lines, state, pos, observer, world, hitFace);
        GameProfile name = this.getPlayerName();
        if (name != null) {
            if (!name.equals((Object)this.cachedDisplayProfile) || this.cachedDisplayStack == null) {
                this.cachedDisplayProfile = name;
                ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                NBTHelper.put(head, "SkullOwner", (Tag)NbtUtils.writeGameProfile((CompoundTag)new CompoundTag(), (GameProfile)name));
                head.getItem().verifyTagAfterLoad(head.getOrCreateTag());
                this.cachedDisplayStack = head;
            }
            lines.add((Pair<ItemStack, Component>)new Pair((Object)this.cachedDisplayStack, (Object)Component.translatable((String)"hexcasting.tooltip.lens.impetus.redstone.bound", (Object[])new Object[]{name.getName()})));
        } else {
            lines.add((Pair<ItemStack, Component>)new Pair((Object)new ItemStack((ItemLike)Items.BARRIER), (Object)Component.translatable((String)"hexcasting.tooltip.lens.impetus.redstone.bound.none")));
        }
    }

    @Override
    protected void saveModData(CompoundTag tag) {
        super.saveModData(tag);
        if (this.storedPlayer != null) {
            tag.putUUID(TAG_STORED_PLAYER, this.storedPlayer);
        }
        if (this.storedPlayerProfile != null) {
            tag.put(TAG_STORED_PLAYER_PROFILE, (Tag)NbtUtils.writeGameProfile((CompoundTag)new CompoundTag(), (GameProfile)this.storedPlayerProfile));
        }
    }

    @Override
    protected void loadModData(CompoundTag tag) {
        super.loadModData(tag);
        this.storedPlayer = tag.contains(TAG_STORED_PLAYER, 11) ? tag.getUUID(TAG_STORED_PLAYER) : null;
        this.storedPlayerProfile = tag.contains(TAG_STORED_PLAYER_PROFILE, 10) ? NbtUtils.readGameProfile((CompoundTag)tag.getCompound(TAG_STORED_PLAYER_PROFILE)) : null;
    }
}

