/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.blocks.circles;

import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.env.CircleCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.blocks.circles.BlockEntitySlate;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockSlate
extends BlockCircleComponent
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<AttachFace> ATTACH_FACE = BlockStateProperties.ATTACH_FACE;
    public static final double THICKNESS = 1.0;
    public static final VoxelShape AABB_FLOOR = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape AABB_CEILING = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape AABB_EAST_WALL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final VoxelShape AABB_WEST_WALL = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape AABB_SOUTH_WALL = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final VoxelShape AABB_NORTH_WALL = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockSlate(BlockBehaviour.Properties p_53182_) {
        super(p_53182_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ENERGIZED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public ICircleComponent.ControlFlow acceptControlFlow(CastingImage imageIn, CircleCastEnv env, Direction enterDir, BlockPos pos, BlockState bs, ServerLevel world) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof BlockEntitySlate)) {
            return new ICircleComponent.ControlFlow.Stop();
        }
        BlockEntitySlate tile = (BlockEntitySlate)blockEntity;
        HexPattern pattern = tile.pattern;
        EnumSet<Direction> exitDirsSet = this.possibleExitDirections(pos, bs, (Level)world);
        exitDirsSet.remove(enterDir.getOpposite());
        Stream<Pair> exitDirs = exitDirsSet.stream().map(dir -> this.exitPositionFromDirection(pos, (Direction)dir));
        if (pattern == null) {
            return new ICircleComponent.ControlFlow.Continue(imageIn, exitDirs.toList());
        }
        CastingVM vm = new CastingVM(imageIn, env);
        ExecutionClientView result = vm.queueExecuteAndWrapIota(new PatternIota(pattern), world);
        if (result.getResolutionType().getSuccess()) {
            return new ICircleComponent.ControlFlow.Continue(vm.getImage(), exitDirs.toList());
        }
        return new ICircleComponent.ControlFlow.Stop();
    }

    @Override
    public boolean canEnterFromDirection(Direction enterDir, BlockPos pos, BlockState bs, ServerLevel world) {
        Direction thisNormal = this.normalDir(pos, bs, (Level)world);
        return enterDir != thisNormal.getOpposite();
    }

    @Override
    public EnumSet<Direction> possibleExitDirections(BlockPos pos, BlockState bs, Level world) {
        EnumSet<Direction> allDirs = EnumSet.allOf(Direction.class);
        Direction normal = this.normalDir(pos, bs, world);
        allDirs.remove(normal);
        return allDirs;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof BlockEntitySlate) {
            BlockEntitySlate slate = (BlockEntitySlate)be;
            ItemStack stack = new ItemStack((ItemLike)HexItems.SLATE);
            if (slate.pattern != null) {
                HexItems.SLATE.writeDatum(stack, new PatternIota(slate.pattern));
            }
            return stack;
        }
        return new ItemStack((ItemLike)this);
    }

    @Override
    public Direction normalDir(BlockPos pos, BlockState bs, Level world, int recursionLeft) {
        return switch ((AttachFace)bs.getValue(ATTACH_FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.WALL -> (Direction)bs.getValue((Property)FACING);
        };
    }

    @Override
    public float particleHeight(BlockPos pos, BlockState bs, Level world) {
        return -0.4375f;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BlockEntitySlate(pPos, pState);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((AttachFace)pState.getValue(ATTACH_FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> AABB_FLOOR;
            case AttachFace.CEILING -> AABB_CEILING;
            case AttachFace.WALL -> {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case NORTH: {
                        yield AABB_NORTH_WALL;
                    }
                    case EAST: {
                        yield AABB_EAST_WALL;
                    }
                    case SOUTH: {
                        yield AABB_SOUTH_WALL;
                    }
                }
                yield AABB_WEST_WALL;
            }
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, ATTACH_FACE, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.getLevel().getFluidState(pContext.getClickedPos());
        for (Direction direction : pContext.getNearestLookingDirections()) {
            BlockState blockstate = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACH_FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite()) : (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACH_FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!(blockstate = (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.is(FluidTags.WATER) && fluidState.getAmount() == 8))).canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlockSlate.canAttach(pLevel, pPos, BlockSlate.getConnectedDirection(pState).getOpposite());
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue()) {
            pLevel.scheduleTick(pCurrentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)pLevel));
        }
        return BlockSlate.getConnectedDirection(pState).getOpposite() == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? pState.getFluidState().createLegacyBlock() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public static boolean canAttach(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.relative(pDirection);
        return pReader.getBlockState(blockpos).isFaceSturdy((BlockGetter)pReader, blockpos, pDirection.getOpposite());
    }

    protected static Direction getConnectedDirection(BlockState pState) {
        return switch ((AttachFace)pState.getValue(ATTACH_FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)pState.getValue((Property)FACING);
        };
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

