/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.particles;

import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConjureParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final SpriteSet sprites;
    public static final ConjureRenderType CONJURE_RENDER_TYPE = new ConjureRenderType();

    ConjureParticle(ClientLevel pLevel, double x, double y, double z, double dx, double dy, double dz, SpriteSet pSprites, int color) {
        super(pLevel, x, y, z, dx, dy, dz);
        this.quadSize *= 0.9f;
        this.setParticleSpeed(dx, dy, dz);
        int r = FastColor.ARGB32.red((int)color);
        int g = FastColor.ARGB32.green((int)color);
        int b = FastColor.ARGB32.blue((int)color);
        this.setColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        this.setAlpha(0.3f);
        this.friction = 0.96f;
        this.gravity = dy != 0.0 && dx != 0.0 && dz != 0.0 ? -0.01f : 0.0f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = pSprites;
        this.oRoll = this.roll = RANDOM.nextFloat(360.0f);
        this.lifetime = (int)(64.0 / ((Math.random() + 3.0) * 0.25));
        this.hasPhysics = false;
        this.setSpriteFromAge(pSprites);
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return CONJURE_RENDER_TYPE;
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.alpha = 1.0f - (float)this.age / (float)this.lifetime;
        this.alpha *= 0.3f;
        this.quadSize *= 0.96f;
    }

    public void setSpriteFromAge(@NotNull SpriteSet pSprite) {
        if (!this.removed) {
            int age = this.age * 4;
            if (age > this.lifetime) {
                age /= 4;
            }
            this.setSprite(pSprite.get(age, this.lifetime));
        }
    }

    private record ConjureRenderType() implements ParticleRenderType
    {
        public void begin(BufferBuilder buf, TextureManager texMan) {
            Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            AbstractTexture tex = texMan.getTexture(TextureAtlas.LOCATION_PARTICLES);
            IClientXplatAbstractions.INSTANCE.setFilterSave(tex, true, false);
            buf.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
            RenderSystem.enableDepthTest();
        }

        public void end(Tesselator tess) {
            tess.end();
            IClientXplatAbstractions.INSTANCE.restoreLastFilter(Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_PARTICLES));
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
        }

        @Override
        public String toString() {
            return "hexcasting:conjure";
        }
    }

    public static class Provider
    implements ParticleProvider<ConjureParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Nullable
        public Particle createParticle(ConjureParticleOptions type, ClientLevel level, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new ConjureParticle(level, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprite, type.color());
        }
    }
}

