/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.client;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.client.ClientCastingStack;
import at.petrak.hexcasting.api.client.HexPatternRenderHolder;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.client.ClientTickCounter;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"renderCastingStack", "", "ps", "Lcom/mojang/blaze3d/vertex/PoseStack;", "player", "Lnet/minecraft/world/entity/player/Player;", "pticks", "", "hexcasting-common-1.20.1"})
@JvmName(name="ClientRenderHelper")
public final class ClientRenderHelper {
    public static final void renderCastingStack(@NotNull PoseStack ps, @NotNull Player player, float pticks) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ClientCastingStack stack = IClientXplatAbstractions.INSTANCE.getClientCastingStack(player);
        int n = stack.getPatterns().size();
        for (int k = 0; k < n; ++k) {
            HexPatternRenderHolder patternRenderHolder;
            if (stack.getPatternHolder(k) == null) continue;
            HexPattern pattern = patternRenderHolder.getPattern();
            int lifetime = patternRenderHolder.getLifetime();
            float lifetimeOffset = (float)lifetime <= 5.0f ? (5.0f - (float)lifetime) / 5.0f : 0.0f;
            ps.pushPose();
            ps.mulPose(Axis.YP.rotationDegrees(((float)player.level().getGameTime() + pticks) * ((float)Math.sin((float)k * 12.543565f) * 3.4f) * ((float)k / 12.43f) % (float)360 + (float)(1 + k) * 45.0f));
            ps.translate(0.0, 1.0 + Math.sin(k) * 0.75, 0.75 + Math.cos((double)k / 8.0) * 0.25 + (double)((float)Math.cos(((float)player.level().getGameTime() + pticks) / (float)(7 + k / 4))) * 0.065);
            ps.scale(0.041666668f * (1.0f - lifetimeOffset), 0.041666668f * (1.0f - lifetimeOffset), 0.041666668f * (1.0f - lifetimeOffset));
            ps.translate(0.0, Math.floor((double)k / 8.0), 0.0);
            ps.translate(0.0, Math.sin((double)((float)player.level().getGameTime() + pticks) / (7.0 + (double)k / 8.0)), 0.0);
            ShaderInstance oldShader = RenderSystem.getShader();
            RenderSystem.setShader(ClientRenderHelper::renderCastingStack$lambda$0);
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            Vec2 com1 = HexPattern.getCenter$default(pattern, 1.0f, null, 2, null);
            Vec2 vec2 = Vec2.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"ZERO");
            List<Vec2> lines1 = pattern.toLines(1.0f, vec2);
            float maxDx = -1.0f;
            float maxDy = -1.0f;
            for (Vec2 line : lines1) {
                float dy;
                float dx = Math.abs(line.x - com1.x);
                if (dx > maxDx) {
                    maxDx = dx;
                }
                if (!((dy = Math.abs(line.y - com1.y)) > maxDy)) continue;
                maxDy = dy;
            }
            float scale = RangesKt.coerceAtMost((float)3.8f, (float)RangesKt.coerceAtMost((float)(6.4f / maxDx), (float)(6.4f / maxDy)));
            Vec2 com2 = HexPattern.getCenter$default(pattern, scale, null, 2, null);
            Vec2 vec22 = com2.negated();
            Intrinsics.checkNotNullExpressionValue((Object)vec22, (String)"com2.negated()");
            List lines2 = CollectionsKt.toMutableList((Collection)pattern.toLines(scale, vec22));
            int n2 = lines2.size();
            for (int i = 0; i < n2; ++i) {
                Vec2 line = (Vec2)lines2.get(i);
                lines2.set(i, new Vec2(line.x, -line.y));
            }
            float variance = 0.65f;
            float speed = 0.1f;
            double stupidHash = player.hashCode();
            List<Vec2> zappy = RenderLib.makeZappy(lines2, RenderLib.findDupIndices(HexPattern.positions$default(pattern, null, 1, null)), 5, variance, speed, 0.2f, 0.0f, 1.0f, stupidHash);
            ColorProvider colorProvider = IXplatAbstractions.INSTANCE.getPigment(player).getColorProvider();
            float f = ClientTickCounter.getTotal() / 2.0f;
            RandomSource randomSource = player.getRandom();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"player.random");
            int outer = colorProvider.getColor(f, patternRenderHolder.getColourPos(randomSource));
            int rgbOnly = outer & 0xFFFFFF;
            int newAlpha = outer >>> 24;
            if (lifetime <= 60) {
                newAlpha = (int)Math.floor((float)lifetime / 60.0f * (float)255);
            }
            int newARGB = newAlpha << 24 | rgbOnly;
            int inner = RenderLib.screenCol(newARGB);
            Matrix4f matrix4f = ps.last().pose();
            Intrinsics.checkNotNullExpressionValue((Object)matrix4f, (String)"ps.last().pose()");
            RenderLib.drawLineSeq(matrix4f, zappy, 0.35f, 0.0f, newARGB, newARGB);
            Matrix4f matrix4f2 = ps.last().pose();
            Intrinsics.checkNotNullExpressionValue((Object)matrix4f2, (String)"ps.last().pose()");
            RenderLib.drawLineSeq(matrix4f2, zappy, 0.14f, 0.01f, inner, inner);
            ps.popPose();
            RenderSystem.setShader(() -> ClientRenderHelper.renderCastingStack$lambda$1(oldShader));
            RenderSystem.enableCull();
        }
    }

    private static final ShaderInstance renderCastingStack$lambda$0() {
        return GameRenderer.getPositionColorShader();
    }

    private static final ShaderInstance renderCastingStack$lambda$1(ShaderInstance $oldShader) {
        return $oldShader;
    }
}

