/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.math;

import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTBuilder;
import at.petrak.hexcasting.api.utils.NbtCompoundBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0016\u001a\u00020\u0003J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0007J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\b\b\u0002\u0010 \u001a\u00020\u001cH\u0007J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0000J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010'\u001a\u00020\rH\u0016J\u000e\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexPattern;", "", "startDir", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "angles", "", "Lat/petrak/hexcasting/api/casting/math/HexAngle;", "(Lat/petrak/hexcasting/api/casting/math/HexDir;Ljava/util/List;)V", "getAngles", "()Ljava/util/List;", "getStartDir", "()Lat/petrak/hexcasting/api/casting/math/HexDir;", "anglesSignature", "", "component1", "component2", "copy", "directions", "", "equals", "", "other", "finalDir", "getCenter", "Lnet/minecraft/world/phys/Vec2;", "hexRadius", "", "origin", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "hashCode", "", "positions", "start", "serializeToNBT", "Lnet/minecraft/nbt/CompoundTag;", "sigsEqual", "that", "toLines", "hexSize", "toString", "tryAppendDir", "newDir", "Companion", "hexcasting-common-1.20.1"})
public final class HexPattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HexDir startDir;
    @NotNull
    private final List<HexAngle> angles;
    @NotNull
    public static final String TAG_START_DIR = "start_dir";
    @NotNull
    public static final String TAG_ANGLES = "angles";
    @JvmField
    @NotNull
    public static final Codec<HexPattern> CODEC;

    public HexPattern(@NotNull HexDir startDir, @NotNull List<HexAngle> angles) {
        Intrinsics.checkNotNullParameter((Object)((Object)startDir), (String)"startDir");
        Intrinsics.checkNotNullParameter(angles, (String)TAG_ANGLES);
        this.startDir = startDir;
        this.angles = angles;
    }

    public /* synthetic */ HexPattern(HexDir hexDir, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(hexDir, list);
    }

    @NotNull
    public final HexDir getStartDir() {
        return this.startDir;
    }

    @NotNull
    public final List<HexAngle> getAngles() {
        return this.angles;
    }

    public final boolean tryAppendDir(@NotNull HexDir newDir) {
        Intrinsics.checkNotNullParameter((Object)((Object)newDir), (String)"newDir");
        Set linesSeen = new LinkedHashSet();
        HexDir compass = this.startDir;
        HexCoord cursor = HexCoord.Companion.getOrigin();
        for (HexAngle a : this.angles) {
            linesSeen.add(TuplesKt.to((Object)cursor, (Object)((Object)compass)));
            linesSeen.add(TuplesKt.to((Object)cursor.plus(compass), (Object)((Object)compass.rotatedBy(HexAngle.BACK))));
            cursor = cursor.plus(compass);
            compass = compass.times(a);
        }
        Pair potentialNewLine = TuplesKt.to((Object)(cursor = cursor.plus(compass)), (Object)((Object)newDir));
        if (linesSeen.contains(potentialNewLine)) {
            return false;
        }
        HexAngle nextAngle = newDir.minus(compass);
        if (nextAngle == HexAngle.BACK) {
            return false;
        }
        this.angles.add(nextAngle);
        return true;
    }

    @JvmOverloads
    @NotNull
    public final List<HexCoord> positions(@NotNull HexCoord start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        ArrayList<HexCoord> out = new ArrayList<HexCoord>(this.angles.size() + 2);
        out.add(start);
        HexDir compass = this.startDir;
        HexCoord cursor = start;
        for (HexAngle a : this.angles) {
            cursor = cursor.plus(compass);
            out.add(cursor);
            compass = compass.times(a);
        }
        out.add(cursor.plus(compass));
        return out;
    }

    public static /* synthetic */ List positions$default(HexPattern hexPattern, HexCoord hexCoord, int n, Object object) {
        if ((n & 1) != 0) {
            hexCoord = HexCoord.Companion.getOrigin();
        }
        return hexPattern.positions(hexCoord);
    }

    @NotNull
    public final List<HexDir> directions() {
        ArrayList<HexDir> out = new ArrayList<HexDir>(this.angles.size() + 1);
        out.add(this.startDir);
        HexDir compass = this.startDir;
        for (HexAngle a : this.angles) {
            compass = compass.times(a);
            out.add(compass);
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HexDir finalDir() {
        void $this$fold$iv;
        Iterable iterable = this.angles;
        HexDir initial$iv = this.startDir;
        boolean $i$f$fold = false;
        HexDir accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void angle;
            HexAngle hexAngle = (HexAngle)((Object)element$iv);
            HexDir acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.times((HexAngle)angle);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompoundTag serializeToNBT() {
        void $this$mapTo$iv$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void nbt$iv;
        String $this$remAssign$iv;
        CompoundTag compoundTag;
        NBTBuilder this_$iv = NBTBuilder.INSTANCE;
        boolean $i$f$invoke = false;
        NBTBuilder this_$iv$iv = this_$iv;
        boolean $i$f$compound = false;
        CompoundTag $this$serializeToNBT_u24lambda_u241 = compoundTag = NbtCompoundBuilder.constructor-impl(new CompoundTag());
        boolean bl = false;
        String string = TAG_START_DIR;
        int value$iv22 = this.startDir.ordinal();
        boolean bl2 = false;
        ByteTag byteTag = ByteTag.valueOf((byte)((byte)value$iv22));
        Intrinsics.checkNotNullExpressionValue((Object)byteTag, (String)"valueOf(value.toByte())");
        Tag value$iv22 = (Tag)byteTag;
        boolean bl3 = false;
        $this$serializeToNBT_u24lambda_u241.put($this$remAssign$iv, (Tag)nbt$iv);
        $this$remAssign$iv = TAG_ANGLES;
        Iterable $this$map$iv = this.angles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void p0;
            HexAngle hexAngle = (HexAngle)((Object)item$iv$iv2);
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(p0.ordinal());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean bl5 = false;
        Iterable $this$map$iv$iv = (Iterable)value$iv22;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            Number number = (Number)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl6 = false;
            collection.add(it$iv.byteValue());
        }
        List list = (List)destination$iv$iv$iv;
        value$iv22 = (Tag)new ByteArrayTag(list);
        bl3 = false;
        $this$serializeToNBT_u24lambda_u241.put($this$remAssign$iv, (Tag)nbt$iv);
        return compoundTag;
    }

    @NotNull
    public final String anglesSignature() {
        StringBuilder stringBuilder;
        StringBuilder $this$anglesSignature_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (HexAngle a : this.angles) {
            $this$anglesSignature_u24lambda_u242.append(switch (WhenMappings.$EnumSwitchMapping$0[a.ordinal()]) {
                case 1 -> "w";
                case 2 -> "e";
                case 3 -> "d";
                case 4 -> "s";
                case 5 -> "a";
                case 6 -> "q";
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final Vec2 getCenter(float hexRadius, @NotNull HexCoord origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Vec2 vec2 = Vec2.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec2, (String)"ZERO");
        Vec2 originPx = HexUtils.coordToPx(origin, hexRadius, vec2);
        List<Vec2> points = this.toLines(hexRadius, originPx);
        return HexUtils.findCenter(points);
    }

    public static /* synthetic */ Vec2 getCenter$default(HexPattern hexPattern, float f, HexCoord hexCoord, int n, Object object) {
        if ((n & 2) != 0) {
            hexCoord = HexCoord.Companion.getOrigin();
        }
        return hexPattern.getCenter(f, hexCoord);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Vec2> toLines(float hexSize, @NotNull Vec2 origin) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Iterable $this$map$iv = HexPattern.positions$default(this, null, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HexCoord hexCoord = (HexCoord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HexUtils.coordToPx((HexCoord)it, hexSize, origin));
        }
        return (List)destination$iv$iv;
    }

    public final boolean sigsEqual(@NotNull HexPattern that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return Intrinsics.areEqual(this.angles, that.angles);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u244.append("HexPattern[");
        $this$toString_u24lambda_u244.append((Object)this.startDir);
        $this$toString_u24lambda_u244.append(", ");
        $this$toString_u24lambda_u244.append(this.anglesSignature());
        $this$toString_u24lambda_u244.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final HexDir component1() {
        return this.startDir;
    }

    @NotNull
    public final List<HexAngle> component2() {
        return this.angles;
    }

    @NotNull
    public final HexPattern copy(@NotNull HexDir startDir, @NotNull List<HexAngle> angles) {
        Intrinsics.checkNotNullParameter((Object)((Object)startDir), (String)"startDir");
        Intrinsics.checkNotNullParameter(angles, (String)TAG_ANGLES);
        return new HexPattern(startDir, angles);
    }

    public static /* synthetic */ HexPattern copy$default(HexPattern hexPattern, HexDir hexDir, List list, int n, Object object) {
        if ((n & 1) != 0) {
            hexDir = hexPattern.startDir;
        }
        if ((n & 2) != 0) {
            list = hexPattern.angles;
        }
        return hexPattern.copy(hexDir, list);
    }

    public int hashCode() {
        int result = this.startDir.hashCode();
        result = result * 31 + ((Object)this.angles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexPattern)) {
            return false;
        }
        HexPattern hexPattern = (HexPattern)other;
        if (this.startDir != hexPattern.startDir) {
            return false;
        }
        return Intrinsics.areEqual(this.angles, hexPattern.angles);
    }

    @JvmOverloads
    @NotNull
    public final List<HexCoord> positions() {
        return HexPattern.positions$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Vec2 getCenter(float hexRadius) {
        return HexPattern.getCenter$default(this, hexRadius, null, 2, null);
    }

    private static final HexDir CODEC$lambda$6$lambda$5(KProperty1 $tmp0, HexPattern p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HexDir)((Object)((Function1)$tmp0).invoke((Object)p0));
    }

    private static final App CODEC$lambda$6(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.STRING.fieldOf(TAG_START_DIR).forGetter(HexPattern::anglesSignature), (App)HexDir.Companion.getCODEC().fieldOf(TAG_ANGLES).forGetter(arg_0 -> HexPattern.CODEC$lambda$6$lambda$5((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, Companion::fromAngles);
    }

    @JvmStatic
    public static final boolean isPattern(@NotNull CompoundTag tag) {
        return Companion.isPattern(tag);
    }

    @JvmStatic
    @NotNull
    public static final HexPattern fromNBT(@NotNull CompoundTag tag) {
        return Companion.fromNBT(tag);
    }

    @JvmStatic
    @NotNull
    public static final HexPattern fromAngles(@NotNull String signature, @NotNull HexDir startDir) {
        return Companion.fromAngles(signature, startDir);
    }

    static {
        Codec codec = RecordCodecBuilder.create(HexPattern::CODEC$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create({instance -> inst\u2026n::fromAngles)\n        })");
        CODEC = codec;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexPattern$Companion;", "", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "TAG_ANGLES", "", "TAG_START_DIR", "fromAngles", "signature", "startDir", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "fromNBT", "tag", "Lnet/minecraft/nbt/CompoundTag;", "isPattern", "", "hexcasting-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPattern(@NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return tag.contains(HexPattern.TAG_START_DIR, 99) && tag.contains(HexPattern.TAG_ANGLES, 7);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HexPattern fromNBT(@NotNull CompoundTag tag) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            HexDir startDir = (HexDir)HexUtils.getSafe$default((Enum[])HexDir.values(), tag.getByte(HexPattern.TAG_START_DIR), null, 2, null);
            byte[] byArray = tag.getByteArray(HexPattern.TAG_ANGLES);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"tag.getByteArray(TAG_ANGLES)");
            byte[] byArray2 = byArray;
            HexAngle[] hexAngleArray = HexAngle.values();
            boolean $i$f$map = false;
            void var7_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void item$iv$iv;
                void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((HexAngle)HexUtils.getSafe$default((Enum[])hexAngleArray, (byte)p0, null, 2, null));
            }
            List angles = (List)destination$iv$iv;
            return new HexPattern(startDir, CollectionsKt.toMutableList((Collection)angles));
        }

        @JvmStatic
        @NotNull
        public final HexPattern fromAngles(@NotNull String signature, @NotNull HexDir startDir) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)((Object)startDir), (String)"startDir");
            HexPattern out = new HexPattern(startDir, null, 2, null);
            HexDir compass = startDir;
            int n = signature.length();
            for (int i = 0; i < n; ++i) {
                HexAngle hexAngle;
                int idx = i;
                char c = signature.charAt(i);
                char c2 = c;
                if (c2 == 'w') {
                    hexAngle = HexAngle.FORWARD;
                } else if (c2 == 'e') {
                    hexAngle = HexAngle.RIGHT;
                } else if (c2 == 'd') {
                    hexAngle = HexAngle.RIGHT_BACK;
                } else if (c2 == 's') {
                    hexAngle = HexAngle.BACK;
                } else if (c2 == 'a') {
                    hexAngle = HexAngle.LEFT_BACK;
                } else if (c2 == 'q') {
                    hexAngle = HexAngle.LEFT;
                } else {
                    throw new IllegalArgumentException("Cannot match " + c + " at idx " + idx + " to a direction");
                }
                HexAngle angle = hexAngle;
                compass = compass.times(angle);
                boolean success2 = out.tryAppendDir(compass);
                if (success2) continue;
                throw new IllegalStateException("Adding the angle " + c + " at index " + idx + " made the pattern invalid by looping back on itself");
            }
            return out;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HexAngle.values().length];
            try {
                nArray[HexAngle.FORWARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.RIGHT_BACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.BACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.LEFT_BACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.LEFT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

